% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappers.R
\name{bru_mapper_aggregate}
\alias{bru_mapper_aggregate}
\alias{ibm_n.bru_mapper_aggregate}
\alias{ibm_n_output.bru_mapper_aggregate}
\alias{ibm_values.bru_mapper_aggregate}
\alias{ibm_jacobian.bru_mapper_aggregate}
\alias{ibm_eval.bru_mapper_aggregate}
\title{Mapper for aggregation}
\usage{
bru_mapper_aggregate(rescale = FALSE, n_block = NULL)

\method{ibm_n}{bru_mapper_aggregate}(mapper, ..., input = NULL, state = NULL, n_state = NULL)

\method{ibm_n_output}{bru_mapper_aggregate}(mapper, input = NULL, ...)

\method{ibm_values}{bru_mapper_aggregate}(mapper, ..., state = NULL, n_state = NULL)

\method{ibm_jacobian}{bru_mapper_aggregate}(mapper, input, state = NULL, ...)

\method{ibm_eval}{bru_mapper_aggregate}(mapper, input, state = NULL, ..., sub_lin = NULL)
}
\arguments{
\item{rescale}{logical; For \code{bru_mapper_aggregate} and \code{bru_mapper_logsumexp},
specifies if the blockwise sums should be normalised by the blockwise weight
sums or not:
\itemize{
\item \code{FALSE}: (default) Straight weighted sum, no rescaling.
\item \code{TRUE}: Divide by the sum of the weight values within each block.
This is useful for integration averages, when the given weights are plain
integration weights. If the weights are \code{NULL} or all ones, this is
the same as dividing by the number of entries in each block.
}}

\item{n_block}{Predetermined number of output blocks. If \code{NULL}, overrides
the maximum block index in the inputs.}

\item{mapper}{A mapper S3 object, inheriting from \code{bru_mapper}.}

\item{...}{Arguments passed on to other methods}

\item{input}{Data input for the mapper.}

\item{state}{A vector of latent state values for the mapping,
of length \code{ibm_n(mapper, inla_f = FALSE)}}

\item{n_state}{integer giving the length of the state vector for mappers
that have state dependent output size.}

\item{sub_lin}{Internal, optional pre-computed sub-mapper information}
}
\description{
Constructs a mapper
that aggregates elements of the input state, so it can be used e.g.
for weighted summation or integration over blocks of values.
}
\details{
\itemize{
\item For \code{bru_mapper_aggregate}, \code{input} should be a list with elements \code{block}
and \code{weights}. \code{block}
should be a vector of the same length as the \code{state}, or \code{NULL}, with \code{NULL}
equivalent to all-1.
If \code{weights} is \code{NULL}, it's interpreted as all-1.
}
}
\examples{
m <- bru_mapper_aggregate()
ibm_eval2(m, list(block = c(1, 2, 1, 2), weights = 1:4), 11:14)

}
\seealso{
\link{bru_mapper}, \link{bru_mapper_generics}

Other mappers: 
\code{\link{bru_get_mapper}()},
\code{\link{bru_mapper.fm_mesh_1d}()},
\code{\link{bru_mapper.fm_mesh_2d}()},
\code{\link{bru_mapper_collect}()},
\code{\link{bru_mapper_const}()},
\code{\link{bru_mapper_factor}()},
\code{\link{bru_mapper_generics}},
\code{\link{bru_mapper_harmonics}()},
\code{\link{bru_mapper_index}()},
\code{\link{bru_mapper_linear}()},
\code{\link{bru_mapper_logsumexp}()},
\code{\link{bru_mapper_marginal}()},
\code{\link{bru_mapper_matrix}()},
\code{\link{bru_mapper_mesh_B}()},
\code{\link{bru_mapper_multi}()},
\code{\link{bru_mapper_pipe}()},
\code{\link{bru_mapper_scale}()},
\code{\link{bru_mapper_shift}()},
\code{\link{bru_mapper_taylor}()},
\code{\link{bru_mapper}()}
}
\concept{mappers}
