% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh.R
\name{pixels}
\alias{pixels}
\title{Generate \code{SpatialPixels} covering an \code{inla.mesh}}
\usage{
pixels(mesh, nx = 150, ny = 150, mask = TRUE)
}
\arguments{
\item{mesh}{An \code{inla.mesh} object}

\item{nx}{Number of pixels in x direction}

\item{ny}{Number of pixels in y direction}

\item{mask}{If logical and TRUE, remove pixels that are outside the mesh.
If \code{mask} is a \code{Spatial} object, only return pixels covered by this object.}
}
\value{
\code{SpatialPixelsDataFrame} covering the mesh
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} in favour of \code{\link[fmesher:fm_pixels]{fmesher::fm_pixels()}}

Generate \code{SpatialPixels} covering an \code{inla.mesh}.
}
\examples{
\donttest{
if (require(ggplot2, quietly = TRUE)) {
  data("mrsea", package = "inlabru")
  pxl <- fm_pixels(
    mrsea$mesh,
    dims = c(50, 50),
    mask = mrsea$boundary,
    format = "sp",
    minimal = TRUE
  )
  ggplot() +
    gg(pxl, fill = "blue", alpha = 0.75) +
    gg(mrsea$mesh)

  pxl <- fm_pixels(
    mrsea$mesh,
    dims = c(50, 50),
    mask = mrsea$boundary,
    format = "sf",
    minimal = TRUE
  )
  ggplot() +
    gg(pxl, geom = "tile", fill = "blue", alpha = 0.75) +
    gg(mrsea$mesh)
}
}

}
\seealso{
\code{\link[=fm_pixels]{fm_pixels()}}
}
\author{
Fabian E. Bachl \email{bachlfab@gmail.com}
}
