% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappers.R
\name{bru_mapper_pipe}
\alias{bru_mapper_pipe}
\alias{ibm_n.bru_mapper_pipe}
\alias{ibm_n_output.bru_mapper_pipe}
\alias{ibm_values.bru_mapper_pipe}
\alias{ibm_jacobian.bru_mapper_pipe}
\alias{ibm_eval.bru_mapper_pipe}
\alias{ibm_eval2.bru_mapper_pipe}
\alias{ibm_simplify.bru_mapper_pipe}
\title{Mapper for linking several mappers in sequence}
\usage{
bru_mapper_pipe(mappers)

\method{ibm_n}{bru_mapper_pipe}(mapper, ..., input = NULL, state = NULL)

\method{ibm_n_output}{bru_mapper_pipe}(mapper, input, state = NULL, ..., n_state = NULL)

\method{ibm_values}{bru_mapper_pipe}(mapper, ...)

\method{ibm_jacobian}{bru_mapper_pipe}(mapper, input, state = NULL, ...)

\method{ibm_eval}{bru_mapper_pipe}(mapper, input, state = NULL, ...)

\method{ibm_eval2}{bru_mapper_pipe}(mapper, input, state = NULL, ...)

\method{ibm_simplify}{bru_mapper_pipe}(mapper, input = NULL, state = NULL, ..., n_state = NULL)
}
\arguments{
\item{mappers}{A list of \code{bru_mapper} objects}

\item{mapper}{A mapper S3 object, inheriting from \code{bru_mapper}.}

\item{...}{Arguments passed on to other methods}

\item{input}{Data input for the mapper.}

\item{state}{A vector of latent state values for the mapping,
of length \code{ibm_n(mapper, inla_f = FALSE)}}

\item{n_state}{integer giving the length of the state vector for mappers
that have state dependent output size.}
}
\description{
Create a pipe mapper, where \code{mappers} is a list of mappers,
and the evaluated output of each mapper is handed as the state to the next
mapper.
The \code{input} format for the \code{ibm_eval} and \code{ibm_jacobian} methods is
a list of inputs, one for each mapper.
}
\section{Methods (by generic)}{
\itemize{
\item \code{ibm_simplify(bru_mapper_pipe)}: Constructs a simplified \code{pipe} mapper. For fully linear pipes, calls \code{\link[=ibm_linear]{ibm_linear()}}.
For partially non-linear pipes, replaces each sequence of linear mappers with a single
\code{\link[=bru_mapper_taylor]{bru_mapper_taylor()}} mapper, while keeping the full list of original mapper
names, allowing the original \code{input} structure to be used also with the simplified
mappers, since the \code{taylor} mappers are not dependent on inputs.

}}
\examples{
m <- bru_mapper_pipe(list(
  scale = bru_mapper_scale(),
  shift = bru_mapper_shift()
))
ibm_eval2(m, input = list(scale = 2, shift = 1:4), state = 1:4)

}
\seealso{
\link{bru_mapper}, \link{bru_mapper_generics}

Other mappers: 
\code{\link{bru_get_mapper}()},
\code{\link{bru_mapper.fm_mesh_1d}()},
\code{\link{bru_mapper.fm_mesh_2d}()},
\code{\link{bru_mapper_aggregate}()},
\code{\link{bru_mapper_collect}()},
\code{\link{bru_mapper_const}()},
\code{\link{bru_mapper_factor}()},
\code{\link{bru_mapper_generics}},
\code{\link{bru_mapper_harmonics}()},
\code{\link{bru_mapper_index}()},
\code{\link{bru_mapper_linear}()},
\code{\link{bru_mapper_logsumexp}()},
\code{\link{bru_mapper_marginal}()},
\code{\link{bru_mapper_matrix}()},
\code{\link{bru_mapper_mesh_B}()},
\code{\link{bru_mapper_multi}()},
\code{\link{bru_mapper_scale}()},
\code{\link{bru_mapper_shift}()},
\code{\link{bru_mapper_taylor}()},
\code{\link{bru_mapper}()}
}
\concept{mappers}
