% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappers.R
\name{bru_mapper.fm_mesh_2d}
\alias{bru_mapper.fm_mesh_2d}
\alias{ibm_n.bru_mapper_fm_mesh_2d}
\alias{ibm_values.bru_mapper_fm_mesh_2d}
\alias{ibm_jacobian.bru_mapper_fm_mesh_2d}
\alias{bru_mapper.inla.mesh}
\alias{ibm_n.bru_mapper_inla_mesh_2d}
\alias{ibm_values.bru_mapper_inla_mesh_2d}
\alias{ibm_jacobian.bru_mapper_inla_mesh_2d}
\title{Mapper for \code{fm_mesh_2d}}
\usage{
\method{bru_mapper}{fm_mesh_2d}(mesh, ...)

\method{ibm_n}{bru_mapper_fm_mesh_2d}(mapper, ...)

\method{ibm_values}{bru_mapper_fm_mesh_2d}(mapper, ...)

\method{ibm_jacobian}{bru_mapper_fm_mesh_2d}(mapper, input, ...)

\method{bru_mapper}{inla.mesh}(mesh, ...)

\method{ibm_n}{bru_mapper_inla_mesh_2d}(mapper, ...)

\method{ibm_values}{bru_mapper_inla_mesh_2d}(mapper, ...)

\method{ibm_jacobian}{bru_mapper_inla_mesh_2d}(mapper, input, ...)
}
\arguments{
\item{mesh}{An \code{fm_mesh_2d} or \code{inla.mesh.2d} object to use as a mapper}

\item{...}{Arguments passed on to other methods}

\item{mapper}{A mapper S3 object, inheriting from \code{bru_mapper}.}

\item{input}{Data input for the mapper.}
}
\description{
Creates a mapper for 2D \code{fm_mesh_2d} objects
}
\section{Functions}{
\itemize{
\item \code{bru_mapper(inla.mesh)}: Creates a mapper for 2D \code{inla.mesh} objects

}}
\examples{
m <- bru_mapper(fmesher::fmexample$mesh)
ibm_n(m)
ibm_eval(m, as.matrix(expand.grid(-2:2, -2:2)), seq_len(ibm_n(m)))

}
\seealso{
\link{bru_mapper}, \link{bru_mapper_generics}

Other mappers: 
\code{\link{bru_get_mapper}()},
\code{\link{bru_mapper.fm_mesh_1d}()},
\code{\link{bru_mapper_aggregate}()},
\code{\link{bru_mapper_collect}()},
\code{\link{bru_mapper_const}()},
\code{\link{bru_mapper_factor}()},
\code{\link{bru_mapper_generics}},
\code{\link{bru_mapper_harmonics}()},
\code{\link{bru_mapper_index}()},
\code{\link{bru_mapper_linear}()},
\code{\link{bru_mapper_logsumexp}()},
\code{\link{bru_mapper_marginal}()},
\code{\link{bru_mapper_matrix}()},
\code{\link{bru_mapper_mesh_B}()},
\code{\link{bru_mapper_multi}()},
\code{\link{bru_mapper_pipe}()},
\code{\link{bru_mapper_scale}()},
\code{\link{bru_mapper_shift}()},
\code{\link{bru_mapper_taylor}()},
\code{\link{bru_mapper}()}
}
\concept{mappers}
