% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifr-chisq-gof-test.R
\name{infer_chisq_gof_test}
\alias{infer_chisq_gof_test}
\title{Chi Square Goodness of Fit Test}
\usage{
infer_chisq_gof_test(data, x, y, correct = FALSE)
}
\arguments{
\item{data}{a \code{data.frame} or \code{tibble}}

\item{x}{factor; column in \code{data}}

\item{y}{expected proportions}

\item{correct}{logical; if TRUE continuity correction is applied}
}
\value{
\code{infer_chisq_gof_test} returns an object of class
\code{"infer_chisq_gof_test"}. An object of class \code{"infer_chisq_gof_test"}
is a list containing the following components:

\item{categories}{levels of \code{x}}
\item{chisquare}{chi square statistic}
\item{deviation}{deviation of observed from frequency}
\item{degrees_of_freedom}{chi square degrees of freedom}
\item{expected_frequency}{expected frequency/proportion}
\item{n_levels}{number of levels of \code{x}}
\item{observed_frequency}{observed frequency/proportion}
\item{pvalue}{p-value}
\item{sample_size}{number of observations}
\item{std_residuals}{standardized residuals}
\item{varname}{name of categorical variable}
}
\description{
Test whether the observed proportions for a categorical variable
differ from hypothesized proportions
}
\section{Deprecated Function}{

\code{chisq_gof()} has been deprecated. Instead use
\code{infer_chisq_gof_test()}
}

\examples{
infer_chisq_gof_test(hsb, race, c(20, 20, 20, 140))

# apply continuity correction
infer_chisq_gof_test(hsb, race, c(20, 20, 20, 140), correct = TRUE)
}
\references{
Sheskin, D. J. 2007. Handbook of Parametric and Nonparametric
Statistical Procedures, 4th edition. : Chapman & Hall/CRC.
}
\seealso{
\code{\link[stats]{chisq.test}}
}
