% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infer-binom-test.R
\name{infer_binom_calc}
\alias{infer_binom_calc}
\alias{binom_calc}
\alias{infer_binom_test}
\alias{binom_test}
\title{Binomial Test}
\usage{
infer_binom_calc(n, success, prob = 0.5, ...)

infer_binom_test(data, variable, prob = 0.5)
}
\arguments{
\item{n}{number of observations}

\item{success}{number of successes}

\item{prob}{assumed probability of success on a trial}

\item{...}{additional arguments passed to or from other methods}

\item{data}{a \code{data.frame} or a \code{tibble}}

\item{variable}{factor; column in \code{data}}
}
\value{
\code{binom_test} returns an object of class \code{"binom_test"}.
An object of class \code{"binom_test"} is a list containing the
following components:

\item{n}{number of observations}
\item{k}{number of successes}
\item{exp_k}{expected number of successes}
\item{obs_p}{assumed probability of success}
\item{exp_p}{expected probability of success}
\item{lower}{lower one sided p value}
\item{upper}{upper one sided p value}
}
\description{
Test whether the proportion of successes on a two-level
categorical dependent variable significantly differs from a hypothesized value.
}
\section{Deprecated Functions}{

\code{binom_calc()} and \code{binom_test()} have been deprecated. Instead use
\code{infer_binom_cal()} and \code{infer_binom_test()}.
}

\examples{
# using calculator
infer_binom_calc(32, 13, prob = 0.5)

# using data set
infer_binom_test(hsb, female, prob = 0.5)
}
\references{
Hoel, P. G. 1984. Introduction to Mathematical Statistics.
5th ed. New York: Wiley.
}
\seealso{
\code{\link[stats]{binom.test}}
}
