% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chi_sq_contingency.R
\name{chisq_test}
\alias{chisq_test}
\title{Chi Square Test of Association}
\usage{
chisq_test(x, y)
}
\arguments{
\item{x}{a categorical variable}

\item{y}{a categorical variable}
}
\value{
\code{chisq_test} returns an object of class \code{"chisq_test"}.
An object of class \code{"chisq_test"} is a list containing the
following components:

\item{chi}{chi square}
\item{chilr}{likelihood ratio chi square}
\item{chimh}{mantel haenszel chi square}
\item{chiy}{continuity adjusted chi square}
\item{sig}{p-value of chi square}
\item{siglr}{p-value of likelihood ratio chi square}
\item{sigmh}{p-value of mantel haenszel chi square}
\item{sigy}{p-value of continuity adjusted chi square}
\item{phi}{phi coefficient}
\item{cc}{contingency coefficient}
\item{cv}{cramer's v}
\item{ds}{product of dimensions of the table of \code{x} and \code{y}}
\item{df}{degrees of freedom}
}
\description{
Chi Square test of association to examine if there is a
relationship between two categorical variables.
}
\examples{
chisq_test(as.factor(hsb$female), as.factor(hsb$schtyp))

chisq_test(as.factor(hsb$female), as.factor(hsb$ses))
}
\references{
Sheskin, D. J. 2007. Handbook of Parametric and Nonparametric
Statistical Procedures, 4th edition. : Chapman & Hall/CRC.
}
\seealso{
\code{\link[stats]{chisq.test}}
}

