% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two-samp-prop-test.R
\name{ts_prop_test}
\alias{ts_prop_calc}
\alias{ts_prop_grp}
\alias{ts_prop_test}
\title{Two Sample Test of Proportion}
\usage{
ts_prop_test(var1, var2, alternative = c("both", "less", "greater", "all"),
  ...)

ts_prop_grp(var, group, alternative = c("both", "less", "greater", "all"))

ts_prop_calc(n1, n2, p1, p2, alternative = c("both", "less", "greater",
  "all"), ...)
}
\arguments{
\item{var1}{a categorical variable}

\item{var2}{a categorical variable}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of "both" (default), "greater", "less" or "all". You can specify
just the initial letter}

\item{...}{additional arguments passed to or from other methods}

\item{var}{a categorical variable}

\item{group}{a categorical variable}

\item{n1}{sample 1 size}

\item{n2}{sample 2 size}

\item{p1}{sample 1 proportion}

\item{p2}{sample 2 proportion}
}
\value{
an object of class \code{"prop_test"}.
An object of class \code{"prop_test"} is a list containing the
following components:

\item{n1}{sample 1 size}
\item{n2}{sample 2 size}
\item{phat1}{sample 1 proportion}
\item{phat2}{sample 2 proportion}
\item{z}{z statistic}
\item{sig}{p-value for z statistic}
\item{alt}{alternative hypothesis}
}
\description{
Tests on the equality of proportions using
large-sample statistics. It tests that a sample has the same proportion
within two independent groups or two samples have the same proportion.
}
\examples{
# using variables
# lower tail
ts_prop_test(var1 = treatment$treatment1, var2 = treatment$treatment2, alternative = 'less')

# upper tail
ts_prop_test(var1 = treatment$treatment1, var2 = treatment$treatment2, alternative = 'greater')

# both tails
ts_prop_test(var1 = treatment$treatment1, var2 = treatment$treatment2, alternative = 'both')

# all tails
ts_prop_test(var1 = treatment$treatment1, var2 = treatment$treatment2, alternative = 'all')

# using groups
# lower tail
ts_prop_grp(var = treatment2$outcome, group = treatment2$female, alternative = 'less')

# upper tail
ts_prop_grp(var = treatment2$outcome, group = treatment2$female, alternative = 'greater')

# both tails
ts_prop_grp(var = treatment2$outcome, group = treatment2$female, alternative = 'both')

# # all tails
ts_prop_grp(var = treatment2$outcome, group = treatment2$female, alternative = 'all')

# using sample size and proportions
# lower tail
ts_prop_calc(n1 = 30, n2 = 25, p1 = 0.3, p2 = 0.5, alternative = 'less')

# upper tail
ts_prop_calc(n1 = 30, n2 = 25, p1 = 0.3, p2 = 0.5, alternative = 'greater')

# both tails
ts_prop_calc(n1 = 30, n2 = 25, p1 = 0.3, p2 = 0.5, alternative = 'both')

# all tails
ts_prop_calc(n1 = 30, n2 = 25, p1 = 0.3, p2 = 0.5, alternative = 'all')
}
\references{
Sheskin, D. J. 2007. Handbook of Parametric and Nonparametric
Statistical Procedures, 4th edition. : Chapman & Hall/CRC.
}
\seealso{
\code{\link[stats]{prop.test}}
}

