% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/best_match.R
\name{best_match}
\alias{best_match}
\title{Tries to correct misspelling of character string}
\usage{
best_match(x, key, clean_text = TRUE, no_match = NA, all = FALSE)
}
\arguments{
\item{x}{is a character string (or a character vector) that should be matched
to the \code{key}}

\item{key}{is a vector containing the correct spellings of the character 
strings.}

\item{clean_text}{(boolean of length one) should arguments \code{x} and 
\code{key} be passed to \code{\link{clean_text}} before matched 
(to ignore special characters)?}

\item{no_match}{Output value if there is no match. Default is NA. The input 
is returned unchanged if not matched and no_match = NULL.}

\item{all}{is a boolean indicator to specify what happens if there is more 
than one match.
Default is \code{FALSE} resulting in a warning message and that only the 
first match is used. The result can then be returned as a vector.
If \code{TRUE}, all possible matches are returned and the result must 
therefore be a list.}
}
\value{
The function returns a character vector of the same length as 
\code{x} if \code{all = FALSE}
but with each element substituted to its best match in the \code{key}-vector.
Strings that could not be matched are NA if (\code{no_match = TRUE}) or 
unchanged if \code{no_match = FALSE}.
If \code{all = TRUE}, one input character string could result in more than 
one output character string. The output might therefore be longer
than the input.
}
\description{
This function uses fuzzy string matching to replace one possibly misspelled
(or in other way not fully correct) character string with a correct version
of the same string.
}
\examples{
best_match(c("Hej_apa!", "erik", "babian"), 
  c("hej apa", "hej bepa", "kungen", "Erik"))
best_match(c("Hej_apa", "erik", "babian"),
   c("hej apa", "hej bepa", "kungen", "Erik"), no_match = FALSE)
}
\seealso{
\link{clean_text}
}
