% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HeatmapExp.R
\name{HeatmapExp}
\alias{HeatmapExp}
\title{HeatmapExp}
\usage{
HeatmapExp(
  x,
  ColorPanel,
  scale,
  cutree_rows,
  cutree_cols,
  cluster,
  show_names,
  NumGenes
)
}
\arguments{
\item{x}{Numeric matrix of log-CPM values (genes × samples), e.g., from edgeR::cpm().}

\item{ColorPanel}{Character. Name of a continuous palette from the paletteer package.}

\item{scale}{Character. Scaling mode for heatmap: "row", "column", or "none".}

\item{cutree_rows}{Integer. Number of clusters for rows (genes).}

\item{cutree_cols}{Integer. Number of clusters for columns (samples).}

\item{cluster}{Character. One of "both", "row", "column", or "none" to specify clustering.}

\item{show_names}{Character. One of "both", "row", "column", or "none" to show row/col names.}

\item{NumGenes}{Integer. Number of top-variance genes to include in the heatmap.}
}
\value{
A "pheatmap" object containing the heatmap and clustering information.
}
\description{
Plot a heatmap of the top variable genes across samples.
}
\details{
This function selects the highest-variance genes from a log-CPM matrix,
transposes the data, and renders a heatmap with customizable clustering,
scaling, and color palettes using pheatmap.
\enumerate{
\item Compute per-gene variance and select the top "NumGenes".
\item Transpose the subsetted matrix so samples are rows.
\item Apply the specified color palette (n = 50) via paletteer::paletteer_c().
\item Determine clustering and name-display options from "cluster" and "show_names".
\item Render the heatmap with "pheatmap::pheatmap()", saving to a temporary file to suppress autosave.
}
}
