% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na_random.R
\name{na_random}
\alias{na_random}
\title{Missing Value Imputation by Random Sample}
\usage{
na_random(x, lower_bound = NULL, upper_bound = NULL, maxgap = Inf)
}
\arguments{
\item{x}{Numeric Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}})
object in which missing values shall be replaced}

\item{lower_bound}{Lower bound for the random samples. 
If nothing or NULL is set min(x) will be used.}

\item{upper_bound}{Upper bound for the random samples. 
If nothing or NULL is set man(x) will be used.}

\item{maxgap}{Maximum number of successive NAs to still perform imputation on.
Default setting is to replace all NAs without restrictions. With this
option set, consecutive NAs runs, that are longer than 'maxgap' will
be left NA. This option mostly makes sense if you want to
treat long runs of NA afterwards separately.}
}
\value{
Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}})
object (dependent on given input at parameter x)
}
\description{
Replaces each missing value by drawing a random sample
between two given bounds.
}
\details{
Replaces each missing value by drawing a random sample between two
given bounds. The default bounds are the minimum and the maximum value in
the non-NAs from the time series. Function uses \link{runif} function to get
the random values.
}
\examples{
# Prerequisite: Create Time series with missing values
x <- ts(c(2, 3, NA, 5, 6, NA, 7, 8))

# Example 1: Replace all NAs by random values that are between min and max of the input time series
na_random(x)

# Example 2: Replace all NAs by random values between 1 and 10
na_random(x, lower_bound = 1, upper_bound = 10)

# Example 3: Same as example 1, just written with pipe operator
x \%>\% na_random()
}
\seealso{
\code{\link[imputeTS]{na_interpolation}},
\code{\link[imputeTS]{na_kalman}}, \code{\link[imputeTS]{na_locf}},
 \code{\link[imputeTS]{na_ma}}, \code{\link[imputeTS]{na_mean}},
 \code{\link[imputeTS]{na_replace}},
 \code{\link[imputeTS]{na_seadec}}, \code{\link[imputeTS]{na_seasplit}}
}
\author{
Steffen Moritz
}
