% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na_locf.R
\name{na_locf}
\alias{na_locf}
\title{Missing Value Imputation by Last Observation Carried Forward}
\usage{
na_locf(x, option = "locf", na_remaining = "rev", maxgap = Inf)
}
\arguments{
\item{x}{Numeric Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}})
object in which missing values shall be replaced}

\item{option}{Algorithm to be used. Accepts the following input:
\itemize{
   \item{"locf" - for Last Observation Carried Forward}
   \item{"nocb" - for Next Observation Carried Backward}
   }}

\item{na_remaining}{Method to be used for remaining NAs.
\itemize{
   \item{"keep" - to return the series with NAs}
   \item{"rm" - to remove remaining NAs}
   \item{"mean" - to replace remaining NAs by overall mean}
   \item{"rev" - to perform nocb / locf from the reverse direction}
   }}

\item{maxgap}{Maximum number of successive NAs to still perform imputation on.
Default setting is to replace all NAs without restrictions. With this
option set, consecutive NAs runs, that are longer than 'maxgap' will
be left NA. This option mostly makes sense if you want to
treat long runs of NA afterwards separately.}
}
\value{
Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}})
object (dependent on given input at parameter x)
}
\description{
Replaces each missing value with the most recent present value
 prior to it (Last Observation Carried Forward- LOCF). Optionally this can
 also be done starting from the back of the series (Next Observation Carried
 Backward - NOCB).
}
\details{
Replaces each missing value with the most recent present value
prior to it (Last Observation Carried Forward- LOCF). This can also be
done from the reverse direction -starting from the back (Next Observation
Carried Backward - NOCB). Both options have the issue, that NAs at the
beginning (or for nocb at the end) of the time series cannot be imputed
(since there is no last value to be carried forward present yet). In this
case there are remaining NAs in the imputed time series. Since this only
concerns very few values at the beginning of the series, na_remaining
offers some quick solutions to get a series without NAs back.
}
\examples{
# Prerequisite: Create Time series with missing values
x <- ts(c(NA, 3, 4, 5, 6, NA, 7, 8))

# Example 1: Perform LOCF
na_locf(x)

# Example 2: Perform NOCF
na_locf(x, option = "nocb")

# Example 3: Perform LOCF and remove remaining NAs
na_locf(x, na_remaining = "rm")

# Example 4: Same as example 1, just written with pipe operator
x \%>\% na_locf()
}
\seealso{
\code{\link[imputeTS]{na_interpolation}},
\code{\link[imputeTS]{na_kalman}},
 \code{\link[imputeTS]{na_ma}}, \code{\link[imputeTS]{na_mean}},
 \code{\link[imputeTS]{na_random}}, \code{\link[imputeTS]{na_replace}},
 \code{\link[imputeTS]{na_seadec}}, \code{\link[imputeTS]{na_seasplit}}
}
\author{
Steffen Moritz
}
