% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funs.R
\name{SimIm}
\alias{SimIm}
\title{Introduce some missing values into a data matrix}
\usage{
SimIm(data, p = 0.1)
}
\arguments{
\item{data}{a data matrix to simulate}

\item{p}{the percentage of missing values introduced into the data matrix
it should be a value between 0 and 1.}
}
\value{
the same size matrix with simulated missing values.
}
\description{
This function randomly introduce some amount of missing values into a matrix.
}
\examples{
# Create data without missing values as example
simdata <- matrix(rnorm(100), 10, 10)

# Now let's introduce some missing values into the dataset
missingdata <- SimIm(simdata, p = 0.15)

# count the number of missing values afterwards
sum(is.na(missingdata))

#------------------

# There is no missing values in the original parkinson data
data(parkinson)

# Let's introduce some missing values into the dataset
missdata <- SimIm(parkinson, 0.1)

# count the number of missing values afterwards
sum(is.na(missdata))
}
\keyword{imputation}
\keyword{simulation,}
