% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_import_funs.R
\name{get_country_inputs_1997_to_present}
\alias{get_country_inputs_1997_to_present}
\title{Return raw flu surveillance data for a specific country}
\usage{
get_country_inputs_1997_to_present(country, max_year)
}
\arguments{
\item{country}{name of country. Run \code{show_available_countries()} for a list of options.}

\item{max_year}{results will be output for all available years up to \code{max_year}.}
}
\value{
A tibble with the following columns:
\itemize{
\item \code{Country}: name of WHO region
\item \code{Year}: calendar year of surveillance
\item \code{n_processed}: total specimens processed
}
}
\description{
Load and return a tibble containing raw influenza surveillance data for the country of interest. Data are from \href{https://apps.who.int/flumart/Default?ReportNo=12}{WHO Flu Mart}.
}
\examples{
get_country_inputs_1997_to_present("Aruba", 1998)
get_country_inputs_1997_to_present("Honduras", 2022)

}
