% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_loading.R
\name{summarise_loading}
\alias{summarise_loading}
\title{Summarise mechanical loading variables}
\usage{
summarise_loading(
  data,
  variable,
  vector,
  daily_average = TRUE,
  ranges_acc = NULL,
  ranges_grf = NULL,
  ranges_lr = NULL,
  save_summary = FALSE
)
}
\arguments{
\item{data}{An \code{impactr_peaks} object, as obtained with
\link[=find_peaks]{find_peaks()} and/or
\link[=predict_loading]{predict_loading()}.}

\item{variable}{A character vector indicating the variable to summarise.
Can be either "acc" (for the acceleration peaks), "grf" (for the ground
reaction force peaks), "lr" (for the loading rate peaks) or "all" (for
all variables).}

\item{vector}{A character string indicating which vector to use to create
the summaries. Can be "resultant", "vertical" or "all".}

\item{daily_average}{Create a daily average summary? Can be \code{TRUE}
(default) or \code{FALSE}.}

\item{ranges_acc, ranges_grf, ranges_lr}{A numeric vector to specify ranges in
which to count the peaks. \emph{E.g.}, If \code{ranges_acc = c(1, 2, 3)},
it will summarise the number of acceleration peaks from 1 to 2\emph{g},
from 2 to 3\emph{g} and above 3\emph{g}. Set to \code{NULL} (default) if
no summary by range will be provided.}

\item{save_summary}{Indicates whether or not to save the summary to a csv
file(s). Defaults to \code{FALSE}. Provide a valid path to a directory
as a character string to save all generated summaries.}
}
\value{
A tibble (or a list of tibbles) with the requested summaries.
}
\description{
Creates a summary table of the selected mechanical loading variables
including the number of peaks, the minimum, maximum, mean and standard
deviation values of these peaks and also the number of peaks inside a
given magnitude range. The summaries can be displayed by day or as a
daily average.
}
\examples{
\donttest{
# Ensure that {accdata} package is available before running the example.
# If it is not, run install_accdata() to install the required package.
if (requireNamespace("accdata", quietly = TRUE)) {
  data <- import_dataset("daily_acc_3d")
  data <- remove_nonwear(data)
  data <- filter_acc(data)
  data <- find_peaks(data, vector = "vertical")
  summarise_loading(
    data,
    variable = "acc", vector = "vertical",
    ranges_acc = 1:5
  )
}
}
}
