% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_repertoire_A_vs_B.R
\name{plot_repertoire_A_vs_B}
\alias{plot_repertoire_A_vs_B}
\title{Comparative plots of main repertoire features of two input repertoires (length distribution, amino acid frequency, VDJ usage, kmer occurrence)}
\usage{
plot_repertoire_A_vs_B(repertoire_A, repertoire_B,
  names_repertoires = c("Repertoire_A", "Repertoire_B"),
  length_aa_plot = 14, output_dir = "", verbose = TRUE)
}
\arguments{
\item{repertoire_A}{An annotated AIRR-compliant immuneSIM repertoire.

(http://docs.airr-community.org/en/latest/)}

\item{repertoire_B}{An annotated AIRR-compliant immuneSIM repertoire.}

\item{names_repertoires}{A vector containing two strings denoting the names of the repertoires / repertoire descriptions.}

\item{length_aa_plot}{Defines sequence length for which the amino acid frequency plot will be made.}

\item{output_dir}{String containing full path of desired output folder. If empty, figures will be output in tempdir().}

\item{verbose}{Determines whether messages on plot locations are output to user. (Default: TRUE)}
}
\value{
TRUE (plots saved as pdfs into subfolder 'figures')
}
\description{
Comparative plots of main repertoire features of two input repertoires (length distribution, amino acid frequency, VDJ usage, kmer occurrence)
}
\examples{
repertoire_A <- list_example_repertoires[["example_repertoire_A"]]
repertoire_B <- list_example_repertoires[["example_repertoire_B"]]
plot_repertoire_A_vs_B(
repertoire_A,
repertoire_B,
c("Sim_repertoire_1","Sim_repertoire_2"),
length_aa_plot = 14,
output_dir="")
}
