% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.R
\name{seqDist}
\alias{seqDist}
\title{Function for computing distance for sequences}
\usage{
seqDist(.data, .col = 'CDR3.nt', .method = 'hamming',
 .group_by = c("V.first", "J.first"), .group_by_seqLength = TRUE, ...)
}
\arguments{
\item{.data}{The data to be processed. Can be \link{data.frame},
\link{data.table}, or a list of these objects.

Every object must have columns in the immunarch compatible format \link{immunarch_data_format}}

\item{.col}{A string that specifies the column name to be processed. The default value is 'CDR3.nt'.}

\item{.method}{Character value or user-defined function.}

\item{.group_by}{Character vector of column names to group sequence by. The default value is c("V.first", "J.first"). Columns "V.first" and "J.first" containing first genes without allele suffixes are calculated automatically from "V.name" and "J.name" if absent in the data. Pass NA for no grouping options.}

\item{.group_by_seqLength}{If TRUE  - adds grouping by sequence length of .col argument}

\item{...}{Extra arguments for user-defined function.

The default value is \code{'hamming'} for Hamming distance which counts the number of character substitutions that turns b into a.
If a and b have different number of characters the distance is Inf.

Other possible values are:

\code{'lv'} for Levenshtein distance which counts the number of deletions, insertions and substitutions necessary to turn b into a.

\code{'lcs'} for longest common substring is defined as the longest string can be obtained by pairing characters from a and b while keeping the order of characters intact.

In case of user-defined function, it should take x and y parameters as input and return \link{dist} object.}
}
\value{
Named list of list with \link{dist} objects for given repertoires for each combination of .group_by variable(s) and/or sequence length of .col.
}
\description{
Computing sequential distances between clonotypes from two repertoires:
}
\examples{

data(immdata)
# Reducing data to save time on examples
immdata$data <- purrr::map(immdata$data, ~ .x \%>\% head(10))
# Computing hamming distance for the first two repertoires in \code{'immdata'}
seqDist(immdata$data[1:2])

# Here we define a custom distance function
# that will count the difference in number of characters in sequences.

f <- function(x, y) {
  res <- matrix(nrow = length(x), ncol = length(y))
  for (i in 1:length(x)) {
    res[i, ] <- abs(nchar(x[i]) - nchar(y))
  }
  dimnames(res) <- list(x, y)
  return(as.dist(res))
}

seqDist(immdata$data[1:2], .method = f, .group_by_seqLength = FALSE)
}
\concept{distance}
