% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplest_color_balance.R
\name{BalanceSimplest}
\alias{BalanceSimplest}
\title{Balance color of image by Simplest Color Balance}
\usage{
BalanceSimplest(im, sleft, sright, range = c(0, 255))
}
\arguments{
\item{im}{a grayscale image of class cimg}

\item{sleft}{left saturation percentage. sleft can be specified by numeric or string, e.g. 1 and "1\%". note that sleft is a percentile.}

\item{sright}{right saturation percentage. sright can be specified by numeric or string. note that sleft is a percentile.}

\item{range}{this function assumes that the range of pixel values of of input image is [0,255] by default. you may prefer [0,1].}
}
\value{
a grayscale image of class cimg
}
\description{
Balance color of image by Simplest Color Balance
}
\examples{
dev.new()
par(mfcol = c(1,2))
boats_g <- grayscale(boats)
plot(boats_g, main = "Original")
BalanceSimplest(boats_g, 1, 1) \%>\% plot(., main = "Simplest Color Balance")
}
\references{
Nicolas Limare, Jose-Luis Lisani, Jean-Michel Morel, Ana Belen Petro, and Catalina Sbert, Simplest Color Balance, Image Processing On Line, 1 (2011), pp. 297-315. \url{https://doi.org/10.5201/ipol.2011.llmps-scb}
}
\author{
Shota Ochi
}
