% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imeval.R
\name{imeval}
\alias{imeval}
\alias{imdo}
\title{Evaluation in an image context}
\usage{
imeval(obj, ..., env = parent.frame())

imdo(obj, form)
}
\arguments{
\item{obj}{an image, pixset or imlist}

\item{...}{one or more formula objects, defining anonymous functions that will be evaluated with the image as first argument (with extra contextual variables added to the evaluation context)}

\item{env}{additional variables (defaults to the calling environment)}

\item{form}{a single formula}
}
\description{
imeval does for images what "with" does for data.frames, namely contextual evaluation. It provides various shortcuts for pixel-wise operations.
imdo runs imeval, and reshapes the output as an image of the same dimensions as the input (useful for functions that return vectors).
imeval takes inspiration from purrr::map in using formulas for defining anonymous functions using the "." argument.
Usage is made clear (hopefully) in the examples.
The old version of imeval used CImg's internal math parser, but has been retired.
}
\section{Functions}{
\itemize{
\item \code{imdo}: run imeval and reshape
}}

\examples{
## Computing mean absolute deviation
imeval(boats, ~ mean(abs(.-median(.))))
##Equivalent to:
mean(abs(boats-median(boats)))
##Two statistics
imeval(boats,mad=  ~ mean(abs(.-median(.))),sd=  ~ sd(.))
##imeval can precompute certain quantities, like the x or y coord. of each pixel
imeval(boats,~ x) \%>\% plot
##same as Xc(boats) \%>\% plot
## Other predefined quantities:
##w is width, h is height
imeval(boats,~ x/w) \%>\% range
##It defines certain transformed coordinate systems:
##Scaled x,y,z
## xs=x/w
## ys=y/h
##Select upper-left quadrant (returns a pixset)
imeval(boats,~ xs<.5 & ys < .5) \%>\% plot
##Fade effect
imeval(boats,~ xs*.) \%>\% plot
## xc and yc are another set of transformed coordinates
## where xc=0,yc=0 is the image center
imeval(boats,~ (abs(xc)/w)*.) \%>\% plot

##rho, theta: circular coordinates. rho is distance to center (in pix.), theta angle
##Gaussian mask with sd 10 pix.
blank <- imfill(30,30)
imeval(blank,~ dnorm(rho,sd=w/3)) \%>\% plot(int=FALSE)
imeval(blank,~ theta) \%>\% plot
##imeval is made for interactive use, meaning it
##accesses the environment it got called from, e.g. this works: 
f <- function()
{
  im1 <- imfill(3,3,val=1)
   im2 <- imfill(3,3,val=3)

  imeval(im1,~ .+im2)
}
f()
##imeval accepts lists as well 
map_il(1:3, ~ isoblur(boats,.)) \%>\%
   imeval(~ xs*.) \%>\%
   plot

##imeval is useful for defining pixsets:
##here, all central pixels that have value under the median
grayscale(boats) \%>\%
    imeval(~ (. > median(.)) & rho < 150) \%>\%
    plot
##other abbreviations are defined:
##s for imshift, b for isoblur, rot for imrotate.
##e.g.
imeval(boats, ~ .*s(.,3)) \%>\% plot

#The rank function outputs a vector
grayscale(boats) \%>\% rank \%>\% class
#Auto-reshape into an image
grayscale(boats)  \%>\% imdo(~ rank(.)) \%>\% plot
#Note that the above performs histogram normalisation

#Also works on lists
imsplit(boats,"c") \%>\% imdo( ~ rank(.)) \%>\% imappend("c") \%>\% plot
}
\seealso{
imchange, which modifies specific parts of an image
}
\author{
Simon Barthelme
}
