% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drawing.R
\name{bucketfill}
\alias{bucketfill}
\title{Bucket fill}
\usage{
bucketfill(im, x, y, z = 1, color, opacity = 1, sigma = 0,
  high_connexity = FALSE)
}
\arguments{
\item{im}{an image}

\item{x}{X-coordinate of the starting point of the region to fill.}

\item{y}{Y-coordinate of the starting point of the region to fill.}

\item{z}{Z-coordinate of the starting point of the region to fill.}

\item{color}{a vector of values (of length spectrum(im)), or a colour name (e.g. "red"). If missing, use the colour at location (x,y,z).}

\item{opacity}{opacity. If the opacity is below 1, paint with transparency.}

\item{sigma}{Tolerance for neighborhood values: spread to neighbours if difference is less than sigma (for grayscale). If there are several channels, the sum of squared differences is used: if it below sigma^2, the colour spreads.}

\item{high_connexity}{Use 8-connexity (only for 2d images, default FALSE).}
}
\description{
Bucket fill
}
\examples{
#Change the colour of a sail 
boats.new <- bucketfill(boats,x=169,y=179,color="pink",sigma=.2) 
layout(t(1:2))
plot(boats,main="Original")
plot(boats.new,main="New sails")

#More spreading, lower opacity, colour specified as vector
ugly <- bucketfill(boats,x=169,y=179,color=c(0,1,0),sigma=.6,opacity=.5)
plot(ugly)
}
\seealso{
px.flood
}
