% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{imeval}
\alias{imeval}
\title{Pixel-wise evaluation of a CImg expression}
\usage{
imeval(im, expr)
}
\arguments{
\item{im}{an image}

\item{expr}{an expression (as string)}
}
\description{
This function provides experimental support for CImg's "math expression parser", a byte-compiled mini-language.
}
\examples{
imfill(10,10) \%>\% imeval('x+y') \%>\% plot
# Box filter
boxf = "v=0;for(iy=y-3,iy<y+3,iy++,for(ix=x-3,ix< x+3,ix++,v+=i(ix,iy)));v"
imeval(boats,boxf) \%>\% plot
# Example by D. Tschumperle: Julia set
julia <-  "
   zr = -1.2 + 2.4*x/w;
   zi = -1.2 + 2.4*y/h;
   for (iter = 0, zr^2+zi^2<=4 && iter<256, iter++,
     t = zr^2 - zi^2 + 0.5;
     (zi *= 2*zr) += 0.2;
     zr = t
   );
   iter"
imfill(500,500) \%>\% imeval(julia) \%>\% plot
}

