% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_validator.R
\name{cv_lasso}
\alias{cv_lasso}
\title{Fit a model using a design matrix with cross validation}
\usage{
cv_lasso(X, y, nfolds = 10, lambda.min.ratio = 1e-04, nlambda = 100,
  lambda = NULL, foldid = NULL, unit = "sample", seed = 0, cl = NULL,
  ...)
}
\arguments{
\item{X}{matrix of explanatory variables}

\item{y}{vector of objective variable}

\item{nfolds}{the number of folds (ignored if foldid is specified)}

\item{lambda.min.ratio}{ratio of max lambda and min lambda (ignored if lambda is specified)}

\item{nlambda}{the number of lambda (ignored if lambda is specified)}

\item{lambda}{lambda sequence}

\item{foldid}{vector indicating id of fold for each sample}

\item{unit}{unit for cross validation error: "sample" (default) or "fold"}

\item{seed}{random seed of cross validation}

\item{cl}{(not yet implemented)}

\item{...}{parameters of lasso function}
}
\value{
lasso model
\item{fit}{lasso model with hole data}
\item{lambda.min}{lambda with minimum cross validation error}
\item{lambda.min.index}{index of lambda.min}
\item{lambda.1se}{largest lambda such that error is within 1 standard error of the minimum}
\item{lambda.1se.index}{index of lambda.1se}
\item{delta}{delta defined above}
\item{foldid}{fold id}
\item{cve}{cross validation error}
\item{cvse}{cross validation standard error}
\item{cvup}{cross validation error + standard error}
\item{cvlo}{cross validation error - standard error}
\item{pe}{prediction error (for family="binomial")}
}
\description{
Fit a model using a design matrix with cross validation
}
\examples{
X <- matrix(c(1,2,3,5,4,7,6,8,9,10), nrow=5, ncol=2)
b <- matrix(c(-1,1), nrow=2, ncol=1)
e <- matrix(c(0,-0.1,0.1,-0.1,0.1), nrow=5, ncol=1)
y <- as.numeric(X \%*\% b + e)
cv_fit <- cv_lasso(X, y, nfolds=5)
fit <- cv_fit$fit
pr <- predict_lasso(fit, X, cv_fit$lambda.min)
plot_cv_lasso(cv_fit)
}
