% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{covCdaC}
\alias{covCdaC}
\title{Optimize a linear regression model by coordinate descent algorithm using a covariance matrix}
\usage{
covCdaC(Gamma, gamma, lambda, R, init_beta, delta = 0, maxit = 10000,
  eps = 1e-04, warm = "lambda", strong = TRUE)
}
\arguments{
\item{Gamma}{covariance matrix of explanatory variables}

\item{gamma}{covariance vector of explanatory and objective variables}

\item{lambda}{lambda sequence}

\item{R}{matrix using exclusive penalty term}

\item{init_beta}{initial values of beta}

\item{delta}{ratio of regularization between l1 and exclusive penalty terms}

\item{maxit}{max iteration}

\item{eps}{convergence threshold for optimization}

\item{warm}{warm start direction: "lambda" (default) or "delta"}

\item{strong}{whether use strong screening or not}
}
\value{
standardized beta
}
\description{
Optimize a linear regression model by coordinate descent algorithm using a covariance matrix
}
\keyword{internal}
