% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis_titles.R
\docType{methods}
\name{add_row_title}
\alias{add_row_title}
\alias{add_row_title,Iheatmap-method}
\title{add_row_title}
\usage{
\S4method{add_row_title}{Iheatmap}(p, title, textangle = ifelse(side ==
  "left", -90, 90), font = get_layout(p)$font, side = c("left", "right"),
  size = 0.1, buffer = 0.01, xname = NULL, yname = current_yaxis(p))
}
\arguments{
\item{p}{iheatmap object}

\item{title}{title of axis}

\item{textangle}{angle of text}

\item{font}{list of plotly font attributes, see 
\url{https://plot.ly/javascript/reference/#layout-font}}

\item{side}{side of plot on which to add subplot}

\item{size}{relative size of subplot relative to main heatmap}

\item{buffer}{amount of space to leave empty before this plot, relative to 
size of first heatmap}

\item{xname}{internal name for xaxis}

\item{yname}{internal name for yaxis}
}
\value{
\code{\link{Iheatmap-class}} object, which can be printed to generate 
an interactive graphic
}
\description{
Add y axis title to plot
}
\examples{

mat <- matrix(rnorm(20), ncol = 5, nrow = 4)  
hm <- iheatmap(mat) \%>\% add_row_title("Samples")

# Print heatmap if interactive session 
if (interactive()) hm 
}
\seealso{
\code{\link{add_col_title}}, \code{\link{iheatmap}}, 
\code{\link{add_row_labels}}
}
\author{
Alicia Schep
}
