% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/afl2.r
\name{infer_ancestry}
\alias{infer_ancestry}
\title{Infer ancestry of GWAS dataset by matching against 1000 genomes allele frequencies}
\usage{
infer_ancestry(d, snpinfo = NULL, opengwas_jwt = get_opengwas_jwt())
}
\arguments{
\item{d}{Data frame containing at least \code{rsid} and \code{eaf} columns.
e.g. output from associations}

\item{snpinfo}{Output from \code{\link{afl2_list}}, \code{\link{afl2_rsid}} or \code{\link{afl2_chrpos}}.
If \code{NULL} then \code{\link[=afl2_list]{afl2_list()}} is used by default}

\item{opengwas_jwt}{Used to authenticate protected endpoints. Login to https://api.opengwas.io to obtain a jwt. Provide the jwt string here, or store in .Renviron under the keyname OPENGWAS_JWT.}
}
\value{
data frame ordered by most likely ancestry, each row represents a super population and cor column represents the correlation between the GWAS dataset and the 1000 genomes super population allele frequencies
}
\description{
Uses ~20k SNPs selected for common frequency across 5 major super populations
}
