% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relerror.R
\encoding{UTF-8}
\name{relerror}
\alias{relerror}
\title{Relative error}
\usage{
relerror(xt, xa)
}
\arguments{
\item{xt}{numeric vector that contains the true value(s)}

\item{xa}{numeric vector that contains the approximate value(s)}
}
\value{
relative error, as a percent (\%), as a numeric \code{\link[base]{vector}}.
}
\description{
This function computes the relative error.
}
\details{
Relative error is expressed as

\deqn{\varepsilon_{t} = \frac{{true \: value} - {approximation}}{true \: value} \cdot 100}

\describe{
\item{\emph{\eqn{\varepsilon_t}}}{the "true percent relative error"}
\item{\emph{true value}}{the true value}
\item{\emph{approximation}}{the approximate value}
}
}
\examples{

library(iemisc)

# Example 4.1 from the Reference text (page 83)

relerror(1.648721, 1.5) # answer as a percent (\\%)



}
\references{
Steven C. Chapra, \emph{Applied Numerical Methods with MATLAB for Engineers and Scientists}, Second Edition, Boston, Massachusetts: McGraw-Hill, 2008, page 82-83.
}
\seealso{
\code{\link{sgm}} for geometric mean, \code{\link{shm}} for harmonic mean, \code{\link{cv}} for
 coefficient of variation (CV), \code{\link{rms}} for root-mean-square (RMS), \code{\link{approxerror}}
 for approximate error, and \code{\link{ranges}} for sample range.
}
\author{
Irucka Embry
}
