% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concr_mix_normal_strength.R
\encoding{UTF-8}
\name{concr_mix_normal_strength}
\alias{concr_mix_normal_strength}
\title{Concrete Mix Design for Normal Strength Concrete}
\source{
r - Convert a character vector of mixed numbers, fractions, and integers to numeric - Stack Overflow answered by G. Grothendieck on May 20 2012 and edited on May 21 2012. See \url{https://stackoverflow.com/questions/10674992/convert-a-character-vector-of-mixed-numbers-fractions-and-integers-to-numeric}.
}
\usage{
concr_mix_normal_strength(fc, slump_use = NULL, max_size_aggr, FM,
  dry_rod_wt_aggr, mc_coarse, mc_fine, entrainment = c("Nonair", "Air"),
  construction_type = c("Reinforced Foundation walls and footings",
  "Plain footings and caissons", "Slabs, beams and reinforced walls",
  "Building Columns", "Pavements and slabs", "Heavy mass construction"),
  slump_value = c("Maximum", "Maximum + 1", "Minimum"))
}
\arguments{
\item{fc}{numeric vector that contains the concrete compressive strength
(psi)}

\item{slump_use}{numeric vector that contains the amount of slump (in)}

\item{max_size_aggr}{numeric vector that contains the maximum aggregate size
(in)}

\item{FM}{numeric vector that contains the "Fineness Modulus of sand"
(dimensionless)}

\item{dry_rod_wt_aggr}{numeric vector that contains the dry rodded weight of
aggregate (lb/ft^3)}

\item{mc_coarse}{numeric vector that contains the moisture content of the
coarse aggregate (whole number percent)}

\item{mc_fine}{numeric vector that contains the moisture content of the
fine aggregate (whole number percent)}

\item{entrainment}{character vector that contains either Air or Nonair
entrainment}

\item{construction_type}{character vector that contains the intended type of
construction}

\item{slump_value}{character vector that contains the slump value (Maximum,
Maximum + 1 inch, or Minimum)}
}
\value{
the amounts of cement, sand, gravel, and water in lb, rounded to the nearest ten, as a
  \code{\link[base]{list}} to make 1 yd^3 of normal strength concrete.
}
\description{
Calculates the amount of cement, sand, gravel, and water needed for 1 yd^3
of normal strength concrete
}
\examples{
library(iemisc)

# "Example 3.1 Mixture Design of Normal-weight Concrete" from Nawy (page 23-28)

concr_mix_normal_strength(fc = 4000, max_size_aggr = 3 / 4, FM = 2.6, dry_rod_wt_aggr =
100, mc_coarse = 3, mc_fine = 2, entrainment = "Nonair", construction_type
= "Reinforced Foundation walls and footings", slump_value = "Maximum")


}
\author{
Irucka Embry
}
\references{
Edward G. Nawy, \emph{Reinforced Concrete: A Fundamental Approach}, 5th Edition, Upper Saddle River, New Jersey: Pearson Prentice Hall, 2005, page 23-28.
}

