% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_support.R
\name{Decode}
\alias{Decode}
\title{Coded choice set to character choice set.}
\usage{
Decode(set, lvl.names, coding, alt.cte, c.lvls = NULL)
}
\arguments{
\item{set}{A numeric matrix which represents a choice set. Each row is a
profile.}

\item{lvl.names}{A list containing character vectors with the values of each
level of each attribute.}

\item{coding}{A character vector denoting the type of coding used for each
attribute. See also \code{\link{Profiles}}.}

\item{alt.cte}{A binary vector indicating for each alternative if an
alternative specific constant is desired.}

\item{c.lvls}{A list containing numeric vectors with the attributelevels for
each continuous attribute. The default is \code{NULL}.}
}
\value{
A character matrix which represents the choice set.
}
\description{
Transforms a coded choice set into a choice set containing character attribute
levels, ready to be used in a survey.
}
\details{
In \code{lvl.names}, the number of character vectors in the list should equal
the number of attributes in de choice set. The number of elements in each
character vector should equal the number of levels for that attribute.

Valid arguments for \code{coding} are \code{C}, \code{D} and \code{E}. When
using \code{C} the attribute will be treated as continuous and no coding will
be applied. All possible levels should then be specified in \code{c.lvls}. If
\code{D} (dummy coding) is used \code{\link{contr.treatment}} will be applied
to that attribute. The first attribute wil be used as reference level.  For
\code{E} (effect coding) \code{\link{contr.sum}} is applied, in this case the
last attributelevel is used as reference level.
}
\examples{
# Example without continuous attributes.
l <- c(3, 4, 2) # 3 Attributes.
c <- c("D", "E", "D") # Coding.
# All profiles.
p <- Profiles(lvls = l, coding = c)
cs <- p[c(4, 8), ] # Choice set 
# Levels as they should appear in survey. 
al <- list(
 c("$50", "$75", "$100"), # Levels attribute 1.
 c("2 min", "15 min", "30 min", "50 min"), # Levels attribute 2.
 c("bad", "good") # Levels attribute 3.
) 
# Decode
Decode(set = cs, lvl.names = al, coding = c, alt.cte = c(0, 0)) 

# Example with continuous attribute.
l <- c(3, 4, 2) # 3 Attributes.
c <- c("D", "C", "D") # Coding.
cl <- list(c(50, 75, 80, 100))
# All profiles.
p <- Profiles(lvls = l, coding = c, c.lvls = cl)
cs <- p[c(4, 8), ] # Set. 
a <- c(1, 0) # Alternative specific constant. 
cs <- cbind(a, cs) # set with alt.cte
# Levels as they should appear in survey. 
al <- list(
  c("$50", "$75", "$100"), # Levels attribute 1.
  c("50 min", "75 min", "80 min", "100 min"), # Levels attribute 2.
  c("bad", "good") # Levels attribute 3.
) 
# Decode
Decode(set = cs, lvl.names = al, coding = c, alt.cte = c(1, 0), c.lvls = cl) 
}
