% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ego_homophily.R
\name{ego_homophily}
\alias{ego_homophily}
\title{Measuring Homophily in Ego Networks (\code{ego_homophily})}
\usage{
ego_homophily(
  ego_id,
  ego_measure,
  alter_ego,
  alter_measure,
  prefix = NULL,
  suffix = NULL,
  prop = FALSE
)
}
\arguments{
\item{ego_id}{A vector of unique ego identifiers located in an ego dataframe. If using data objects created by \code{\link{ego_netwrite}}, this should be the data frame entitled \code{egos}.}

\item{ego_measure}{A vector of attributes corresponding to each ego.}

\item{alter_ego}{A vector of ego identifiers located in an alter dataframe. If using data objects created by \code{\link{ego_netwrite}}, this should be the data frame entitled \code{alters}.}

\item{alter_measure}{A vector of attributes corresponding to each alter}

\item{prefix}{A character value indicating the desired prefix for the calculated homophily measure.}

\item{suffix}{A character value indicating the desired suffix for the calculated homophily measure.}

\item{prop}{A logical value indicating whether homophily should be represented as a count or as a proportion.}
}
\value{
\code{ego_homophily} returns a dataframe of vectors that include the ego identifier and the number or proportion of alters with the same selected attribute
}
\description{
The \code{ego_homophily} function identifies how similar ego is from their alters on a given attribute.
}
\examples{

# Run `ego_netwrite`
ngq_nw <- ego_netwrite(egos = ngq_egos,
                      ego_id = ngq_egos$ego_id,

                      alters = ngq_alters,
                      alter_id = ngq_alters$alter_id,
                      alter_ego = ngq_alters$ego_id,

                      max_alters = 10,
                      alter_alter = ngq_aa,
                      aa_ego = ngq_aa$ego_id,
                      i_elements = ngq_aa$alter1,
                      j_elements = ngq_aa$alter2,
                      directed = FALSE)


# Homophily as a Count
race_homophily_count <- ego_homophily(ego_id = ngq_nw$egos$ego_id,
                                     ego_measure = ngq_nw$egos$race,
                                     alter_ego = ngq_nw$alters$ego_id,
                                     alter_measure = ngq_nw$alters$race,
                                     suffix = "race")

race_homophily_count

# Homophily as a Proportion
race_homophily_prop <- ego_homophily(ego_id = ngq_nw$egos$ego_id,
                                    ego_measure = ngq_nw$egos$race,
                                    alter_ego = ngq_nw$alters$ego_id,
                                    alter_measure = ngq_nw$alters$race,
                                    prop = TRUE,
                                    suffix = "race")
race_homophily_prop
}
