% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rstan_generics.R
\docType{methods}
\name{id_post_pred,idealstan-method}
\alias{id_post_pred,idealstan-method}
\title{Posterior Prediction for \code{idealstan} objects}
\usage{
\S4method{id_post_pred}{idealstan}(object, draws = 100,
  output = "observed", type = "predict", sample_scores = NULL, ...)
}
\arguments{
\item{object}{A fitted \code{idealstan} object}

\item{draws}{The number of draws to use from the total number of posterior draws (default is 100).}

\item{output}{If the model has an unbounded outcome (Poisson, continuous, etc.), then
specify whether to show the \code{'observed'} data (the default) or the binary 
output \code{'missing'} showing whether an observation was predicted as missing or not}

\item{type}{Whether to produce posterior predictive values (\code{'predict'}, the default),
or log-likelihood values (\code{'log_lik'}). See the How to Evaluate Models vignette for more info.}

\item{sample_scores}{In addition to reducing the number of posterior draws used to 
calculate the posterior predictive distribution, which will reduce computational overhead.
Only available for calculating predictive distributions, not log-likelihood values.}

\item{...}{Any other arguments passed on to posterior_predict (currently none available)}
}
\description{
This function will draw from the posterior distribution, whether in terms of the outcome (prediction)
or to produce the log-likelihood values.  
 
 This function can also produce either distribution of the 
 outcomes (i.e., predictions) or the log-likelihood values of the posterior (set option 
 \code{type} to \code{'log_lik'}.
 For more information, see the package vignette How to Evaluate Models.
 
 You can then use functions such as 
 \code{\link{id_plot_ppc}} to see how well the model does returning the correct number of categories
 in the score/vote matrix. 
 Also see \code{help("posterior_predict", package = "rstanarm")}
}
