/* 
  
  We will use the standard GPL license for this package_version

*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.17.0

#include <stan/model/model_header.hpp>

namespace model_irt_standard_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_irt_standard");
    reader.add_event(1462, 1462, "end", "model_irt_standard");
    return reader;
}

class model_irt_standard : public prob_grad {
private:
    int N;
    int T;
    vector<int> Y;
    int model_type;
    int hier_type;
    int LX;
    int SRX;
    int SAX;
    int num_legis;
    int num_bills;
    int constrain_par;
    int constraint_type;
    int num_fix_high;
    int num_fix_low;
    vector<int> ll;
    vector<int> bb;
    vector<int> time;
    vector_d particip;
    vector<matrix_d> legis_pred;
    matrix_d srx_pred;
    matrix_d sax_pred;
    vector_d pin_vals;
    double discrim_reg_sd;
    double discrim_abs_sd;
    double legis_sd;
    double diff_abs_sd;
    double diff_reg_sd;
    double restrict_sd;
    double restrict_low_bar;
    double restrict_high_bar;
    double restrict_alpha;
    double restrict_beta;
    int m;
    vector<int> absence;
    int num_constrain_l;
    int num_constrain_sa;
    int num_constrain_sr;
    vector<int> Y_new;
public:
    model_irt_standard(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_irt_standard(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_irt_standard_namespace::model_irt_standard";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            context__.validate_dims("data initialization", "T", "int", context__.to_vec());
            T = int(0);
            vals_i__ = context__.vals_i("T");
            pos__ = 0;
            T = vals_i__[pos__++];
            validate_non_negative_index("Y", "N", N);
            context__.validate_dims("data initialization", "Y", "int", context__.to_vec(N));
            validate_non_negative_index("Y", "N", N);
            Y = std::vector<int>(N,int(0));
            vals_i__ = context__.vals_i("Y");
            pos__ = 0;
            size_t Y_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < Y_limit_0__; ++i_0__) {
                Y[i_0__] = vals_i__[pos__++];
            }
            context__.validate_dims("data initialization", "model_type", "int", context__.to_vec());
            model_type = int(0);
            vals_i__ = context__.vals_i("model_type");
            pos__ = 0;
            model_type = vals_i__[pos__++];
            context__.validate_dims("data initialization", "hier_type", "int", context__.to_vec());
            hier_type = int(0);
            vals_i__ = context__.vals_i("hier_type");
            pos__ = 0;
            hier_type = vals_i__[pos__++];
            context__.validate_dims("data initialization", "LX", "int", context__.to_vec());
            LX = int(0);
            vals_i__ = context__.vals_i("LX");
            pos__ = 0;
            LX = vals_i__[pos__++];
            context__.validate_dims("data initialization", "SRX", "int", context__.to_vec());
            SRX = int(0);
            vals_i__ = context__.vals_i("SRX");
            pos__ = 0;
            SRX = vals_i__[pos__++];
            context__.validate_dims("data initialization", "SAX", "int", context__.to_vec());
            SAX = int(0);
            vals_i__ = context__.vals_i("SAX");
            pos__ = 0;
            SAX = vals_i__[pos__++];
            context__.validate_dims("data initialization", "num_legis", "int", context__.to_vec());
            num_legis = int(0);
            vals_i__ = context__.vals_i("num_legis");
            pos__ = 0;
            num_legis = vals_i__[pos__++];
            context__.validate_dims("data initialization", "num_bills", "int", context__.to_vec());
            num_bills = int(0);
            vals_i__ = context__.vals_i("num_bills");
            pos__ = 0;
            num_bills = vals_i__[pos__++];
            context__.validate_dims("data initialization", "constrain_par", "int", context__.to_vec());
            constrain_par = int(0);
            vals_i__ = context__.vals_i("constrain_par");
            pos__ = 0;
            constrain_par = vals_i__[pos__++];
            context__.validate_dims("data initialization", "constraint_type", "int", context__.to_vec());
            constraint_type = int(0);
            vals_i__ = context__.vals_i("constraint_type");
            pos__ = 0;
            constraint_type = vals_i__[pos__++];
            context__.validate_dims("data initialization", "num_fix_high", "int", context__.to_vec());
            num_fix_high = int(0);
            vals_i__ = context__.vals_i("num_fix_high");
            pos__ = 0;
            num_fix_high = vals_i__[pos__++];
            context__.validate_dims("data initialization", "num_fix_low", "int", context__.to_vec());
            num_fix_low = int(0);
            vals_i__ = context__.vals_i("num_fix_low");
            pos__ = 0;
            num_fix_low = vals_i__[pos__++];
            validate_non_negative_index("ll", "N", N);
            context__.validate_dims("data initialization", "ll", "int", context__.to_vec(N));
            validate_non_negative_index("ll", "N", N);
            ll = std::vector<int>(N,int(0));
            vals_i__ = context__.vals_i("ll");
            pos__ = 0;
            size_t ll_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < ll_limit_0__; ++i_0__) {
                ll[i_0__] = vals_i__[pos__++];
            }
            validate_non_negative_index("bb", "N", N);
            context__.validate_dims("data initialization", "bb", "int", context__.to_vec(N));
            validate_non_negative_index("bb", "N", N);
            bb = std::vector<int>(N,int(0));
            vals_i__ = context__.vals_i("bb");
            pos__ = 0;
            size_t bb_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < bb_limit_0__; ++i_0__) {
                bb[i_0__] = vals_i__[pos__++];
            }
            validate_non_negative_index("time", "N", N);
            context__.validate_dims("data initialization", "time", "int", context__.to_vec(N));
            validate_non_negative_index("time", "N", N);
            time = std::vector<int>(N,int(0));
            vals_i__ = context__.vals_i("time");
            pos__ = 0;
            size_t time_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < time_limit_0__; ++i_0__) {
                time[i_0__] = vals_i__[pos__++];
            }
            validate_non_negative_index("particip", "num_legis", num_legis);
            context__.validate_dims("data initialization", "particip", "vector_d", context__.to_vec(num_legis));
            validate_non_negative_index("particip", "num_legis", num_legis);
            particip = vector_d(static_cast<Eigen::VectorXd::Index>(num_legis));
            vals_r__ = context__.vals_r("particip");
            pos__ = 0;
            size_t particip_i_vec_lim__ = num_legis;
            for (size_t i_vec__ = 0; i_vec__ < particip_i_vec_lim__; ++i_vec__) {
                particip[i_vec__] = vals_r__[pos__++];
            }
            validate_non_negative_index("legis_pred", "T", T);
            validate_non_negative_index("legis_pred", "num_legis", num_legis);
            validate_non_negative_index("legis_pred", "LX", LX);
            context__.validate_dims("data initialization", "legis_pred", "matrix_d", context__.to_vec(T,num_legis,LX));
            validate_non_negative_index("legis_pred", "T", T);
            validate_non_negative_index("legis_pred", "num_legis", num_legis);
            validate_non_negative_index("legis_pred", "LX", LX);
            legis_pred = std::vector<matrix_d>(T,matrix_d(static_cast<Eigen::VectorXd::Index>(num_legis),static_cast<Eigen::VectorXd::Index>(LX)));
            vals_r__ = context__.vals_r("legis_pred");
            pos__ = 0;
            size_t legis_pred_m_mat_lim__ = num_legis;
            size_t legis_pred_n_mat_lim__ = LX;
            for (size_t n_mat__ = 0; n_mat__ < legis_pred_n_mat_lim__; ++n_mat__) {
                for (size_t m_mat__ = 0; m_mat__ < legis_pred_m_mat_lim__; ++m_mat__) {
                    size_t legis_pred_limit_0__ = T;
                    for (size_t i_0__ = 0; i_0__ < legis_pred_limit_0__; ++i_0__) {
                        legis_pred[i_0__](m_mat__,n_mat__) = vals_r__[pos__++];
            }
                }
            }
            validate_non_negative_index("srx_pred", "num_bills", num_bills);
            validate_non_negative_index("srx_pred", "SRX", SRX);
            context__.validate_dims("data initialization", "srx_pred", "matrix_d", context__.to_vec(num_bills,SRX));
            validate_non_negative_index("srx_pred", "num_bills", num_bills);
            validate_non_negative_index("srx_pred", "SRX", SRX);
            srx_pred = matrix_d(static_cast<Eigen::VectorXd::Index>(num_bills),static_cast<Eigen::VectorXd::Index>(SRX));
            vals_r__ = context__.vals_r("srx_pred");
            pos__ = 0;
            size_t srx_pred_m_mat_lim__ = num_bills;
            size_t srx_pred_n_mat_lim__ = SRX;
            for (size_t n_mat__ = 0; n_mat__ < srx_pred_n_mat_lim__; ++n_mat__) {
                for (size_t m_mat__ = 0; m_mat__ < srx_pred_m_mat_lim__; ++m_mat__) {
                    srx_pred(m_mat__,n_mat__) = vals_r__[pos__++];
                }
            }
            validate_non_negative_index("sax_pred", "num_bills", num_bills);
            validate_non_negative_index("sax_pred", "SAX", SAX);
            context__.validate_dims("data initialization", "sax_pred", "matrix_d", context__.to_vec(num_bills,SAX));
            validate_non_negative_index("sax_pred", "num_bills", num_bills);
            validate_non_negative_index("sax_pred", "SAX", SAX);
            sax_pred = matrix_d(static_cast<Eigen::VectorXd::Index>(num_bills),static_cast<Eigen::VectorXd::Index>(SAX));
            vals_r__ = context__.vals_r("sax_pred");
            pos__ = 0;
            size_t sax_pred_m_mat_lim__ = num_bills;
            size_t sax_pred_n_mat_lim__ = SAX;
            for (size_t n_mat__ = 0; n_mat__ < sax_pred_n_mat_lim__; ++n_mat__) {
                for (size_t m_mat__ = 0; m_mat__ < sax_pred_m_mat_lim__; ++m_mat__) {
                    sax_pred(m_mat__,n_mat__) = vals_r__[pos__++];
                }
            }
            validate_non_negative_index("pin_vals", "num_fix_high", num_fix_high);
            context__.validate_dims("data initialization", "pin_vals", "vector_d", context__.to_vec(num_fix_high));
            validate_non_negative_index("pin_vals", "num_fix_high", num_fix_high);
            pin_vals = vector_d(static_cast<Eigen::VectorXd::Index>(num_fix_high));
            vals_r__ = context__.vals_r("pin_vals");
            pos__ = 0;
            size_t pin_vals_i_vec_lim__ = num_fix_high;
            for (size_t i_vec__ = 0; i_vec__ < pin_vals_i_vec_lim__; ++i_vec__) {
                pin_vals[i_vec__] = vals_r__[pos__++];
            }
            context__.validate_dims("data initialization", "discrim_reg_sd", "double", context__.to_vec());
            discrim_reg_sd = double(0);
            vals_r__ = context__.vals_r("discrim_reg_sd");
            pos__ = 0;
            discrim_reg_sd = vals_r__[pos__++];
            context__.validate_dims("data initialization", "discrim_abs_sd", "double", context__.to_vec());
            discrim_abs_sd = double(0);
            vals_r__ = context__.vals_r("discrim_abs_sd");
            pos__ = 0;
            discrim_abs_sd = vals_r__[pos__++];
            context__.validate_dims("data initialization", "legis_sd", "double", context__.to_vec());
            legis_sd = double(0);
            vals_r__ = context__.vals_r("legis_sd");
            pos__ = 0;
            legis_sd = vals_r__[pos__++];
            context__.validate_dims("data initialization", "diff_abs_sd", "double", context__.to_vec());
            diff_abs_sd = double(0);
            vals_r__ = context__.vals_r("diff_abs_sd");
            pos__ = 0;
            diff_abs_sd = vals_r__[pos__++];
            context__.validate_dims("data initialization", "diff_reg_sd", "double", context__.to_vec());
            diff_reg_sd = double(0);
            vals_r__ = context__.vals_r("diff_reg_sd");
            pos__ = 0;
            diff_reg_sd = vals_r__[pos__++];
            context__.validate_dims("data initialization", "restrict_sd", "double", context__.to_vec());
            restrict_sd = double(0);
            vals_r__ = context__.vals_r("restrict_sd");
            pos__ = 0;
            restrict_sd = vals_r__[pos__++];
            context__.validate_dims("data initialization", "restrict_low_bar", "double", context__.to_vec());
            restrict_low_bar = double(0);
            vals_r__ = context__.vals_r("restrict_low_bar");
            pos__ = 0;
            restrict_low_bar = vals_r__[pos__++];
            context__.validate_dims("data initialization", "restrict_high_bar", "double", context__.to_vec());
            restrict_high_bar = double(0);
            vals_r__ = context__.vals_r("restrict_high_bar");
            pos__ = 0;
            restrict_high_bar = vals_r__[pos__++];
            context__.validate_dims("data initialization", "restrict_alpha", "double", context__.to_vec());
            restrict_alpha = double(0);
            vals_r__ = context__.vals_r("restrict_alpha");
            pos__ = 0;
            restrict_alpha = vals_r__[pos__++];
            context__.validate_dims("data initialization", "restrict_beta", "double", context__.to_vec());
            restrict_beta = double(0);
            vals_r__ = context__.vals_r("restrict_beta");
            pos__ = 0;
            restrict_beta = vals_r__[pos__++];

            // validate, data variables
            check_greater_or_equal(function__,"num_legis",num_legis,1);
            check_greater_or_equal(function__,"num_bills",num_bills,1);
            // initialize data variables
            m = int(0);
            stan::math::fill(m, std::numeric_limits<int>::min());
            validate_non_negative_index("absence", "N", N);
            absence = std::vector<int>(N,int(0));
            stan::math::fill(absence, std::numeric_limits<int>::min());
            num_constrain_l = int(0);
            stan::math::fill(num_constrain_l, std::numeric_limits<int>::min());
            num_constrain_sa = int(0);
            stan::math::fill(num_constrain_sa, std::numeric_limits<int>::min());
            num_constrain_sr = int(0);
            stan::math::fill(num_constrain_sr, std::numeric_limits<int>::min());
            validate_non_negative_index("Y_new", "N", N);
            Y_new = std::vector<int>(N,int(0));
            stan::math::fill(Y_new, std::numeric_limits<int>::min());

            if (as_bool((primitive_value(logical_eq(model_type,4)) || primitive_value(logical_eq(model_type,6))))) {

                stan::math::assign(m, (max(Y) - 1));
            } else if (as_bool((primitive_value(logical_eq(model_type,1)) || primitive_value(logical_eq(model_type,2))))) {

                stan::math::assign(m, 2);
            } else {

                stan::math::assign(m, max(Y));
            }
            for (int n = 1; n <= N; ++n) {

                if (as_bool(logical_gt(get_base1(Y,n,"Y",1),m))) {

                    stan::math::assign(get_base1_lhs(absence,n,"absence",1), 1);
                } else {

                    stan::math::assign(get_base1_lhs(absence,n,"absence",1), 0);
                }
                if (as_bool((primitive_value(logical_eq(model_type,1)) || primitive_value(logical_eq(model_type,2))))) {

                    if (as_bool(logical_gt(min(Y),0))) {

                        stan::math::assign(get_base1_lhs(Y_new,n,"Y_new",1), (get_base1(Y,n,"Y",1) - min(Y)));
                    } else {

                        stan::math::assign(get_base1_lhs(Y_new,n,"Y_new",1), get_base1(Y,n,"Y",1));
                    }
                }
            }
            if (as_bool(logical_eq(constraint_type,1))) {

                if (as_bool(logical_eq(constrain_par,1))) {

                    stan::math::assign(num_constrain_l, num_fix_low);
                    stan::math::assign(num_constrain_sr, 0);
                    stan::math::assign(num_constrain_sa, 0);
                } else if (as_bool(logical_eq(constrain_par,2))) {

                    stan::math::assign(num_constrain_l, 0);
                    stan::math::assign(num_constrain_sr, 0);
                    stan::math::assign(num_constrain_sa, num_fix_low);
                } else if (as_bool(logical_eq(constrain_par,3))) {

                    stan::math::assign(num_constrain_l, 0);
                    stan::math::assign(num_constrain_sr, num_fix_low);
                    stan::math::assign(num_constrain_sa, 0);
                }
            } else if (as_bool((primitive_value(logical_eq(constraint_type,2)) || primitive_value(logical_eq(constraint_type,4))))) {

                if (as_bool(logical_eq(constrain_par,1))) {

                    stan::math::assign(num_constrain_l, num_fix_high);
                    stan::math::assign(num_constrain_sr, 0);
                    stan::math::assign(num_constrain_sa, 0);
                } else if (as_bool(logical_eq(constrain_par,2))) {

                    stan::math::assign(num_constrain_l, 0);
                    stan::math::assign(num_constrain_sr, 0);
                    stan::math::assign(num_constrain_sa, num_fix_high);
                } else if (as_bool(logical_eq(constrain_par,3))) {

                    stan::math::assign(num_constrain_l, 0);
                    stan::math::assign(num_constrain_sr, num_fix_high);
                    stan::math::assign(num_constrain_sa, 0);
                }
            } else if (as_bool(logical_eq(constraint_type,3))) {

                if (as_bool(logical_eq(constrain_par,1))) {

                    stan::math::assign(num_constrain_l, (num_fix_high + num_fix_low));
                    stan::math::assign(num_constrain_sr, 0);
                    stan::math::assign(num_constrain_sa, 0);
                } else if (as_bool(logical_eq(constrain_par,2))) {

                    stan::math::assign(num_constrain_l, 0);
                    stan::math::assign(num_constrain_sr, 0);
                    stan::math::assign(num_constrain_sa, (num_fix_high + num_fix_low));
                } else if (as_bool(logical_eq(constrain_par,3))) {

                    stan::math::assign(num_constrain_l, 0);
                    stan::math::assign(num_constrain_sr, (num_fix_high + num_fix_low));
                    stan::math::assign(num_constrain_sa, 0);
                }
            }

            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            validate_non_negative_index("sigma_abs_free", "(num_bills - num_constrain_sa)", (num_bills - num_constrain_sa));
            num_params_r__ += (num_bills - num_constrain_sa);
            validate_non_negative_index("L_free", "(num_legis - num_constrain_l)", (num_legis - num_constrain_l));
            validate_non_negative_index("L_free", "T", T);
            num_params_r__ += (num_legis - num_constrain_l) * T;
            validate_non_negative_index("sigma_reg_free", "(num_bills - num_constrain_sr)", (num_bills - num_constrain_sr));
            num_params_r__ += (num_bills - num_constrain_sr);
            validate_non_negative_index("restrict_low", "num_fix_low", num_fix_low);
            validate_non_negative_index("restrict_low", "T", T);
            num_params_r__ += num_fix_low * T;
            validate_non_negative_index("restrict_high", "num_fix_high", num_fix_high);
            validate_non_negative_index("restrict_high", "T", T);
            num_params_r__ += num_fix_high * T;
            validate_non_negative_index("pinned_pars", "num_fix_high", num_fix_high);
            validate_non_negative_index("pinned_pars", "T", T);
            num_params_r__ += num_fix_high * T;
            validate_non_negative_index("legis_x", "LX", LX);
            num_params_r__ += LX;
            validate_non_negative_index("sigma_reg_x", "SRX", SRX);
            num_params_r__ += SRX;
            validate_non_negative_index("sigma_abs_x", "SAX", SAX);
            num_params_r__ += SAX;
            validate_non_negative_index("legis_x_cons", "LX", LX);
            num_params_r__ += LX;
            validate_non_negative_index("sigma_reg_x_cons", "SRX", SRX);
            num_params_r__ += SRX;
            validate_non_negative_index("sigma_abs_x_cons", "SAX", SAX);
            num_params_r__ += SAX;
            validate_non_negative_index("B_int_free", "num_bills", num_bills);
            num_params_r__ += num_bills;
            validate_non_negative_index("A_int_free", "num_bills", num_bills);
            num_params_r__ += num_bills;
            validate_non_negative_index("steps_votes", "(m - 1)", (m - 1));
            num_params_r__ += (m - 1);
            validate_non_negative_index("steps_votes_grm", "(m - 1)", (m - 1));
            validate_non_negative_index("steps_votes_grm", "num_bills", num_bills);
            num_params_r__ += (m - 1) * num_bills;
            validate_non_negative_index("restrict_ord", "(num_fix_low + num_fix_high)", (num_fix_low + num_fix_high));
            validate_non_negative_index("restrict_ord", "T", T);
            num_params_r__ += (num_fix_low + num_fix_high) * T;
            ++num_params_r__;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_irt_standard() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("sigma_abs_free")))
            throw std::runtime_error("variable sigma_abs_free missing");
        vals_r__ = context__.vals_r("sigma_abs_free");
        pos__ = 0U;
        validate_non_negative_index("sigma_abs_free", "(num_bills - num_constrain_sa)", (num_bills - num_constrain_sa));
        context__.validate_dims("initialization", "sigma_abs_free", "vector_d", context__.to_vec((num_bills - num_constrain_sa)));
        vector_d sigma_abs_free(static_cast<Eigen::VectorXd::Index>((num_bills - num_constrain_sa)));
        for (int j1__ = 0U; j1__ < (num_bills - num_constrain_sa); ++j1__)
            sigma_abs_free(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(sigma_abs_free);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_abs_free: ") + e.what());
        }

        if (!(context__.contains_r("L_free")))
            throw std::runtime_error("variable L_free missing");
        vals_r__ = context__.vals_r("L_free");
        pos__ = 0U;
        validate_non_negative_index("L_free", "T", T);
        validate_non_negative_index("L_free", "(num_legis - num_constrain_l)", (num_legis - num_constrain_l));
        context__.validate_dims("initialization", "L_free", "vector_d", context__.to_vec(T,(num_legis - num_constrain_l)));
        std::vector<vector_d> L_free(T,vector_d(static_cast<Eigen::VectorXd::Index>((num_legis - num_constrain_l))));
        for (int j1__ = 0U; j1__ < (num_legis - num_constrain_l); ++j1__)
            for (int i0__ = 0U; i0__ < T; ++i0__)
                L_free[i0__](j1__) = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < T; ++i0__)
            try {
            writer__.vector_unconstrain(L_free[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable L_free: ") + e.what());
        }

        if (!(context__.contains_r("sigma_reg_free")))
            throw std::runtime_error("variable sigma_reg_free missing");
        vals_r__ = context__.vals_r("sigma_reg_free");
        pos__ = 0U;
        validate_non_negative_index("sigma_reg_free", "(num_bills - num_constrain_sr)", (num_bills - num_constrain_sr));
        context__.validate_dims("initialization", "sigma_reg_free", "vector_d", context__.to_vec((num_bills - num_constrain_sr)));
        vector_d sigma_reg_free(static_cast<Eigen::VectorXd::Index>((num_bills - num_constrain_sr)));
        for (int j1__ = 0U; j1__ < (num_bills - num_constrain_sr); ++j1__)
            sigma_reg_free(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(sigma_reg_free);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_reg_free: ") + e.what());
        }

        if (!(context__.contains_r("restrict_low")))
            throw std::runtime_error("variable restrict_low missing");
        vals_r__ = context__.vals_r("restrict_low");
        pos__ = 0U;
        validate_non_negative_index("restrict_low", "T", T);
        validate_non_negative_index("restrict_low", "num_fix_low", num_fix_low);
        context__.validate_dims("initialization", "restrict_low", "vector_d", context__.to_vec(T,num_fix_low));
        std::vector<vector_d> restrict_low(T,vector_d(static_cast<Eigen::VectorXd::Index>(num_fix_low)));
        for (int j1__ = 0U; j1__ < num_fix_low; ++j1__)
            for (int i0__ = 0U; i0__ < T; ++i0__)
                restrict_low[i0__](j1__) = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < T; ++i0__)
            try {
            writer__.vector_ub_unconstrain(restrict_low_bar,restrict_low[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable restrict_low: ") + e.what());
        }

        if (!(context__.contains_r("restrict_high")))
            throw std::runtime_error("variable restrict_high missing");
        vals_r__ = context__.vals_r("restrict_high");
        pos__ = 0U;
        validate_non_negative_index("restrict_high", "T", T);
        validate_non_negative_index("restrict_high", "num_fix_high", num_fix_high);
        context__.validate_dims("initialization", "restrict_high", "vector_d", context__.to_vec(T,num_fix_high));
        std::vector<vector_d> restrict_high(T,vector_d(static_cast<Eigen::VectorXd::Index>(num_fix_high)));
        for (int j1__ = 0U; j1__ < num_fix_high; ++j1__)
            for (int i0__ = 0U; i0__ < T; ++i0__)
                restrict_high[i0__](j1__) = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < T; ++i0__)
            try {
            writer__.vector_lb_unconstrain(restrict_high_bar,restrict_high[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable restrict_high: ") + e.what());
        }

        if (!(context__.contains_r("pinned_pars")))
            throw std::runtime_error("variable pinned_pars missing");
        vals_r__ = context__.vals_r("pinned_pars");
        pos__ = 0U;
        validate_non_negative_index("pinned_pars", "T", T);
        validate_non_negative_index("pinned_pars", "num_fix_high", num_fix_high);
        context__.validate_dims("initialization", "pinned_pars", "vector_d", context__.to_vec(T,num_fix_high));
        std::vector<vector_d> pinned_pars(T,vector_d(static_cast<Eigen::VectorXd::Index>(num_fix_high)));
        for (int j1__ = 0U; j1__ < num_fix_high; ++j1__)
            for (int i0__ = 0U; i0__ < T; ++i0__)
                pinned_pars[i0__](j1__) = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < T; ++i0__)
            try {
            writer__.vector_unconstrain(pinned_pars[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable pinned_pars: ") + e.what());
        }

        if (!(context__.contains_r("legis_x")))
            throw std::runtime_error("variable legis_x missing");
        vals_r__ = context__.vals_r("legis_x");
        pos__ = 0U;
        validate_non_negative_index("legis_x", "LX", LX);
        context__.validate_dims("initialization", "legis_x", "vector_d", context__.to_vec(LX));
        vector_d legis_x(static_cast<Eigen::VectorXd::Index>(LX));
        for (int j1__ = 0U; j1__ < LX; ++j1__)
            legis_x(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(legis_x);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable legis_x: ") + e.what());
        }

        if (!(context__.contains_r("sigma_reg_x")))
            throw std::runtime_error("variable sigma_reg_x missing");
        vals_r__ = context__.vals_r("sigma_reg_x");
        pos__ = 0U;
        validate_non_negative_index("sigma_reg_x", "SRX", SRX);
        context__.validate_dims("initialization", "sigma_reg_x", "vector_d", context__.to_vec(SRX));
        vector_d sigma_reg_x(static_cast<Eigen::VectorXd::Index>(SRX));
        for (int j1__ = 0U; j1__ < SRX; ++j1__)
            sigma_reg_x(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(sigma_reg_x);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_reg_x: ") + e.what());
        }

        if (!(context__.contains_r("sigma_abs_x")))
            throw std::runtime_error("variable sigma_abs_x missing");
        vals_r__ = context__.vals_r("sigma_abs_x");
        pos__ = 0U;
        validate_non_negative_index("sigma_abs_x", "SAX", SAX);
        context__.validate_dims("initialization", "sigma_abs_x", "vector_d", context__.to_vec(SAX));
        vector_d sigma_abs_x(static_cast<Eigen::VectorXd::Index>(SAX));
        for (int j1__ = 0U; j1__ < SAX; ++j1__)
            sigma_abs_x(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(sigma_abs_x);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_abs_x: ") + e.what());
        }

        if (!(context__.contains_r("legis_x_cons")))
            throw std::runtime_error("variable legis_x_cons missing");
        vals_r__ = context__.vals_r("legis_x_cons");
        pos__ = 0U;
        validate_non_negative_index("legis_x_cons", "LX", LX);
        context__.validate_dims("initialization", "legis_x_cons", "vector_d", context__.to_vec(LX));
        vector_d legis_x_cons(static_cast<Eigen::VectorXd::Index>(LX));
        for (int j1__ = 0U; j1__ < LX; ++j1__)
            legis_x_cons(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(legis_x_cons);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable legis_x_cons: ") + e.what());
        }

        if (!(context__.contains_r("sigma_reg_x_cons")))
            throw std::runtime_error("variable sigma_reg_x_cons missing");
        vals_r__ = context__.vals_r("sigma_reg_x_cons");
        pos__ = 0U;
        validate_non_negative_index("sigma_reg_x_cons", "SRX", SRX);
        context__.validate_dims("initialization", "sigma_reg_x_cons", "vector_d", context__.to_vec(SRX));
        vector_d sigma_reg_x_cons(static_cast<Eigen::VectorXd::Index>(SRX));
        for (int j1__ = 0U; j1__ < SRX; ++j1__)
            sigma_reg_x_cons(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(sigma_reg_x_cons);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_reg_x_cons: ") + e.what());
        }

        if (!(context__.contains_r("sigma_abs_x_cons")))
            throw std::runtime_error("variable sigma_abs_x_cons missing");
        vals_r__ = context__.vals_r("sigma_abs_x_cons");
        pos__ = 0U;
        validate_non_negative_index("sigma_abs_x_cons", "SAX", SAX);
        context__.validate_dims("initialization", "sigma_abs_x_cons", "vector_d", context__.to_vec(SAX));
        vector_d sigma_abs_x_cons(static_cast<Eigen::VectorXd::Index>(SAX));
        for (int j1__ = 0U; j1__ < SAX; ++j1__)
            sigma_abs_x_cons(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(sigma_abs_x_cons);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_abs_x_cons: ") + e.what());
        }

        if (!(context__.contains_r("B_int_free")))
            throw std::runtime_error("variable B_int_free missing");
        vals_r__ = context__.vals_r("B_int_free");
        pos__ = 0U;
        validate_non_negative_index("B_int_free", "num_bills", num_bills);
        context__.validate_dims("initialization", "B_int_free", "vector_d", context__.to_vec(num_bills));
        vector_d B_int_free(static_cast<Eigen::VectorXd::Index>(num_bills));
        for (int j1__ = 0U; j1__ < num_bills; ++j1__)
            B_int_free(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(B_int_free);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable B_int_free: ") + e.what());
        }

        if (!(context__.contains_r("A_int_free")))
            throw std::runtime_error("variable A_int_free missing");
        vals_r__ = context__.vals_r("A_int_free");
        pos__ = 0U;
        validate_non_negative_index("A_int_free", "num_bills", num_bills);
        context__.validate_dims("initialization", "A_int_free", "vector_d", context__.to_vec(num_bills));
        vector_d A_int_free(static_cast<Eigen::VectorXd::Index>(num_bills));
        for (int j1__ = 0U; j1__ < num_bills; ++j1__)
            A_int_free(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(A_int_free);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable A_int_free: ") + e.what());
        }

        if (!(context__.contains_r("steps_votes")))
            throw std::runtime_error("variable steps_votes missing");
        vals_r__ = context__.vals_r("steps_votes");
        pos__ = 0U;
        validate_non_negative_index("steps_votes", "(m - 1)", (m - 1));
        context__.validate_dims("initialization", "steps_votes", "vector_d", context__.to_vec((m - 1)));
        vector_d steps_votes(static_cast<Eigen::VectorXd::Index>((m - 1)));
        for (int j1__ = 0U; j1__ < (m - 1); ++j1__)
            steps_votes(j1__) = vals_r__[pos__++];
        try {
            writer__.ordered_unconstrain(steps_votes);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable steps_votes: ") + e.what());
        }

        if (!(context__.contains_r("steps_votes_grm")))
            throw std::runtime_error("variable steps_votes_grm missing");
        vals_r__ = context__.vals_r("steps_votes_grm");
        pos__ = 0U;
        validate_non_negative_index("steps_votes_grm", "num_bills", num_bills);
        validate_non_negative_index("steps_votes_grm", "(m - 1)", (m - 1));
        context__.validate_dims("initialization", "steps_votes_grm", "vector_d", context__.to_vec(num_bills,(m - 1)));
        std::vector<vector_d> steps_votes_grm(num_bills,vector_d(static_cast<Eigen::VectorXd::Index>((m - 1))));
        for (int j1__ = 0U; j1__ < (m - 1); ++j1__)
            for (int i0__ = 0U; i0__ < num_bills; ++i0__)
                steps_votes_grm[i0__](j1__) = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < num_bills; ++i0__)
            try {
            writer__.ordered_unconstrain(steps_votes_grm[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable steps_votes_grm: ") + e.what());
        }

        if (!(context__.contains_r("restrict_ord")))
            throw std::runtime_error("variable restrict_ord missing");
        vals_r__ = context__.vals_r("restrict_ord");
        pos__ = 0U;
        validate_non_negative_index("restrict_ord", "T", T);
        validate_non_negative_index("restrict_ord", "(num_fix_low + num_fix_high)", (num_fix_low + num_fix_high));
        context__.validate_dims("initialization", "restrict_ord", "vector_d", context__.to_vec(T,(num_fix_low + num_fix_high)));
        std::vector<vector_d> restrict_ord(T,vector_d(static_cast<Eigen::VectorXd::Index>((num_fix_low + num_fix_high))));
        for (int j1__ = 0U; j1__ < (num_fix_low + num_fix_high); ++j1__)
            for (int i0__ = 0U; i0__ < T; ++i0__)
                restrict_ord[i0__](j1__) = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < T; ++i0__)
            try {
            writer__.ordered_unconstrain(restrict_ord[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable restrict_ord: ") + e.what());
        }

        if (!(context__.contains_r("avg_particip")))
            throw std::runtime_error("variable avg_particip missing");
        vals_r__ = context__.vals_r("avg_particip");
        pos__ = 0U;
        context__.validate_dims("initialization", "avg_particip", "double", context__.to_vec());
        double avg_particip(0);
        avg_particip = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(avg_particip);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable avg_particip: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<T__> in__(params_r__,params_i__);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma_abs_free;
            (void) sigma_abs_free;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_abs_free = in__.vector_constrain((num_bills - num_constrain_sa),lp__);
            else
                sigma_abs_free = in__.vector_constrain((num_bills - num_constrain_sa));

            vector<Eigen::Matrix<T__,Eigen::Dynamic,1> > L_free;
            size_t dim_L_free_0__ = T;
            L_free.reserve(dim_L_free_0__);
            for (size_t k_0__ = 0; k_0__ < dim_L_free_0__; ++k_0__) {
                if (jacobian__)
                    L_free.push_back(in__.vector_constrain((num_legis - num_constrain_l),lp__));
                else
                    L_free.push_back(in__.vector_constrain((num_legis - num_constrain_l)));
            }

            Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma_reg_free;
            (void) sigma_reg_free;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_reg_free = in__.vector_constrain((num_bills - num_constrain_sr),lp__);
            else
                sigma_reg_free = in__.vector_constrain((num_bills - num_constrain_sr));

            vector<Eigen::Matrix<T__,Eigen::Dynamic,1> > restrict_low;
            size_t dim_restrict_low_0__ = T;
            restrict_low.reserve(dim_restrict_low_0__);
            for (size_t k_0__ = 0; k_0__ < dim_restrict_low_0__; ++k_0__) {
                if (jacobian__)
                    restrict_low.push_back(in__.vector_ub_constrain(restrict_low_bar,num_fix_low,lp__));
                else
                    restrict_low.push_back(in__.vector_ub_constrain(restrict_low_bar,num_fix_low));
            }

            vector<Eigen::Matrix<T__,Eigen::Dynamic,1> > restrict_high;
            size_t dim_restrict_high_0__ = T;
            restrict_high.reserve(dim_restrict_high_0__);
            for (size_t k_0__ = 0; k_0__ < dim_restrict_high_0__; ++k_0__) {
                if (jacobian__)
                    restrict_high.push_back(in__.vector_lb_constrain(restrict_high_bar,num_fix_high,lp__));
                else
                    restrict_high.push_back(in__.vector_lb_constrain(restrict_high_bar,num_fix_high));
            }

            vector<Eigen::Matrix<T__,Eigen::Dynamic,1> > pinned_pars;
            size_t dim_pinned_pars_0__ = T;
            pinned_pars.reserve(dim_pinned_pars_0__);
            for (size_t k_0__ = 0; k_0__ < dim_pinned_pars_0__; ++k_0__) {
                if (jacobian__)
                    pinned_pars.push_back(in__.vector_constrain(num_fix_high,lp__));
                else
                    pinned_pars.push_back(in__.vector_constrain(num_fix_high));
            }

            Eigen::Matrix<T__,Eigen::Dynamic,1>  legis_x;
            (void) legis_x;  // dummy to suppress unused var warning
            if (jacobian__)
                legis_x = in__.vector_constrain(LX,lp__);
            else
                legis_x = in__.vector_constrain(LX);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma_reg_x;
            (void) sigma_reg_x;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_reg_x = in__.vector_constrain(SRX,lp__);
            else
                sigma_reg_x = in__.vector_constrain(SRX);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma_abs_x;
            (void) sigma_abs_x;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_abs_x = in__.vector_constrain(SAX,lp__);
            else
                sigma_abs_x = in__.vector_constrain(SAX);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  legis_x_cons;
            (void) legis_x_cons;  // dummy to suppress unused var warning
            if (jacobian__)
                legis_x_cons = in__.vector_constrain(LX,lp__);
            else
                legis_x_cons = in__.vector_constrain(LX);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma_reg_x_cons;
            (void) sigma_reg_x_cons;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_reg_x_cons = in__.vector_constrain(SRX,lp__);
            else
                sigma_reg_x_cons = in__.vector_constrain(SRX);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma_abs_x_cons;
            (void) sigma_abs_x_cons;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_abs_x_cons = in__.vector_constrain(SAX,lp__);
            else
                sigma_abs_x_cons = in__.vector_constrain(SAX);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  B_int_free;
            (void) B_int_free;  // dummy to suppress unused var warning
            if (jacobian__)
                B_int_free = in__.vector_constrain(num_bills,lp__);
            else
                B_int_free = in__.vector_constrain(num_bills);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  A_int_free;
            (void) A_int_free;  // dummy to suppress unused var warning
            if (jacobian__)
                A_int_free = in__.vector_constrain(num_bills,lp__);
            else
                A_int_free = in__.vector_constrain(num_bills);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  steps_votes;
            (void) steps_votes;  // dummy to suppress unused var warning
            if (jacobian__)
                steps_votes = in__.ordered_constrain((m - 1),lp__);
            else
                steps_votes = in__.ordered_constrain((m - 1));

            vector<Eigen::Matrix<T__,Eigen::Dynamic,1> > steps_votes_grm;
            size_t dim_steps_votes_grm_0__ = num_bills;
            steps_votes_grm.reserve(dim_steps_votes_grm_0__);
            for (size_t k_0__ = 0; k_0__ < dim_steps_votes_grm_0__; ++k_0__) {
                if (jacobian__)
                    steps_votes_grm.push_back(in__.ordered_constrain((m - 1),lp__));
                else
                    steps_votes_grm.push_back(in__.ordered_constrain((m - 1)));
            }

            vector<Eigen::Matrix<T__,Eigen::Dynamic,1> > restrict_ord;
            size_t dim_restrict_ord_0__ = T;
            restrict_ord.reserve(dim_restrict_ord_0__);
            for (size_t k_0__ = 0; k_0__ < dim_restrict_ord_0__; ++k_0__) {
                if (jacobian__)
                    restrict_ord.push_back(in__.ordered_constrain((num_fix_low + num_fix_high),lp__));
                else
                    restrict_ord.push_back(in__.ordered_constrain((num_fix_low + num_fix_high)));
            }

            T__ avg_particip;
            (void) avg_particip;  // dummy to suppress unused var warning
            if (jacobian__)
                avg_particip = in__.scalar_constrain(lp__);
            else
                avg_particip = in__.scalar_constrain();


            // transformed parameters
            validate_non_negative_index("L_full", "num_legis", num_legis);
            validate_non_negative_index("L_full", "T", T);
            vector<Eigen::Matrix<T__,Eigen::Dynamic,1> > L_full(T, (Eigen::Matrix<T__,Eigen::Dynamic,1> (static_cast<Eigen::VectorXd::Index>(num_legis))));
            stan::math::initialize(L_full, DUMMY_VAR__);
            stan::math::fill(L_full,DUMMY_VAR__);
            validate_non_negative_index("sigma_abs_full", "num_bills", num_bills);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma_abs_full(static_cast<Eigen::VectorXd::Index>(num_bills));
            (void) sigma_abs_full;  // dummy to suppress unused var warning

            stan::math::initialize(sigma_abs_full, DUMMY_VAR__);
            stan::math::fill(sigma_abs_full,DUMMY_VAR__);
            validate_non_negative_index("sigma_reg_full", "num_bills", num_bills);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma_reg_full(static_cast<Eigen::VectorXd::Index>(num_bills));
            (void) sigma_reg_full;  // dummy to suppress unused var warning

            stan::math::initialize(sigma_reg_full, DUMMY_VAR__);
            stan::math::fill(sigma_reg_full,DUMMY_VAR__);
            validate_non_negative_index("B_int_full", "num_bills", num_bills);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  B_int_full(static_cast<Eigen::VectorXd::Index>(num_bills));
            (void) B_int_full;  // dummy to suppress unused var warning

            stan::math::initialize(B_int_full, DUMMY_VAR__);
            stan::math::fill(B_int_full,DUMMY_VAR__);
            validate_non_negative_index("A_int_full", "num_bills", num_bills);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  A_int_full(static_cast<Eigen::VectorXd::Index>(num_bills));
            (void) A_int_full;  // dummy to suppress unused var warning

            stan::math::initialize(A_int_full, DUMMY_VAR__);
            stan::math::fill(A_int_full,DUMMY_VAR__);


            stan::math::assign(B_int_full, B_int_free);
            stan::math::assign(A_int_full, A_int_free);
            if (as_bool(logical_eq(constrain_par,1))) {

                if (as_bool(logical_eq(constraint_type,1))) {

                    for (int t = 1; t <= T; ++t) {

                        stan::math::assign(get_base1_lhs(L_full,t,"L_full",1), append_row(get_base1(L_free,t,"L_free",1),get_base1(restrict_low,t,"restrict_low",1)));
                    }
                } else if (as_bool(logical_eq(constraint_type,2))) {

                    for (int t = 1; t <= T; ++t) {

                        stan::math::assign(get_base1_lhs(L_full,t,"L_full",1), append_row(get_base1(L_free,t,"L_free",1),get_base1(restrict_high,t,"restrict_high",1)));
                    }
                } else if (as_bool(logical_eq(constraint_type,3))) {

                    for (int t = 1; t <= T; ++t) {

                        stan::math::assign(get_base1_lhs(L_full,t,"L_full",1), append_row(get_base1(L_free,t,"L_free",1),append_row(get_base1(restrict_high,t,"restrict_high",1),get_base1(restrict_low,t,"restrict_low",1))));
                    }
                } else if (as_bool(logical_eq(constraint_type,4))) {

                    for (int t = 1; t <= T; ++t) {

                        stan::math::assign(get_base1_lhs(L_full,t,"L_full",1), append_row(get_base1(L_free,t,"L_free",1),get_base1(pinned_pars,t,"pinned_pars",1)));
                    }
                }
                stan::math::assign(sigma_abs_full, sigma_abs_free);
                stan::math::assign(sigma_reg_full, sigma_reg_free);
            } else if (as_bool(logical_eq(constrain_par,2))) {

                if (as_bool(logical_eq(constraint_type,1))) {

                    stan::math::assign(sigma_abs_full, append_row(sigma_abs_free,get_base1(restrict_low,1,"restrict_low",1)));
                } else if (as_bool(logical_eq(constraint_type,2))) {

                    stan::math::assign(sigma_abs_full, append_row(sigma_abs_free,get_base1(restrict_high,1,"restrict_high",1)));
                } else if (as_bool(logical_eq(constraint_type,3))) {

                    stan::math::assign(sigma_abs_full, append_row(sigma_abs_free,append_row(get_base1(restrict_high,1,"restrict_high",1),get_base1(restrict_low,1,"restrict_low",1))));
                } else if (as_bool(logical_eq(constraint_type,4))) {

                    stan::math::assign(sigma_abs_full, append_row(sigma_abs_free,get_base1(pinned_pars,1,"pinned_pars",1)));
                }
                stan::math::assign(L_full, L_free);
                stan::math::assign(sigma_reg_full, sigma_reg_free);
            } else if (as_bool(logical_eq(constrain_par,3))) {

                if (as_bool(logical_eq(constraint_type,1))) {

                    stan::math::assign(sigma_reg_full, append_row(sigma_reg_free,get_base1(restrict_low,1,"restrict_low",1)));
                } else if (as_bool(logical_eq(constraint_type,2))) {

                    stan::math::assign(sigma_reg_full, append_row(sigma_reg_free,get_base1(restrict_high,1,"restrict_high",1)));
                } else if (as_bool(logical_eq(constraint_type,3))) {

                    stan::math::assign(sigma_reg_full, append_row(sigma_reg_free,append_row(get_base1(restrict_high,1,"restrict_high",1),get_base1(restrict_low,1,"restrict_low",1))));
                } else if (as_bool(logical_eq(constraint_type,4))) {

                    stan::math::assign(sigma_reg_full, append_row(sigma_reg_free,get_base1(pinned_pars,1,"pinned_pars",1)));
                }
                stan::math::assign(sigma_abs_full, sigma_abs_free);
                stan::math::assign(L_full, L_free);
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < T; ++i0__) {
                for (int i1__ = 0; i1__ < num_legis; ++i1__) {
                    if (stan::math::is_uninitialized(L_full[i0__](i1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: L_full" << '[' << i0__ << ']' << '[' << i1__ << ']';
                        throw std::runtime_error(msg__.str());
                    }
                }
            }
            for (int i0__ = 0; i0__ < num_bills; ++i0__) {
                if (stan::math::is_uninitialized(sigma_abs_full(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: sigma_abs_full" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < num_bills; ++i0__) {
                if (stan::math::is_uninitialized(sigma_reg_full(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: sigma_reg_full" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < num_bills; ++i0__) {
                if (stan::math::is_uninitialized(B_int_full(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: B_int_full" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < num_bills; ++i0__) {
                if (stan::math::is_uninitialized(A_int_full(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: A_int_full" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning

            // model body
            {
            validate_non_negative_index("pi1", "N", N);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  pi1(static_cast<Eigen::VectorXd::Index>(N));
            (void) pi1;  // dummy to suppress unused var warning

            stan::math::initialize(pi1, DUMMY_VAR__);
            stan::math::fill(pi1,DUMMY_VAR__);
            validate_non_negative_index("pi2", "N", N);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  pi2(static_cast<Eigen::VectorXd::Index>(N));
            (void) pi2;  // dummy to suppress unused var warning

            stan::math::initialize(pi2, DUMMY_VAR__);
            stan::math::fill(pi2,DUMMY_VAR__);


            lp_accum__.add(normal_log<propto__>(legis_x, 0, 5));
            lp_accum__.add(normal_log<propto__>(legis_x_cons, 0, 5));
            lp_accum__.add(normal_log<propto__>(sigma_abs_x, 0, 5));
            lp_accum__.add(normal_log<propto__>(sigma_reg_x, 0, 5));
            lp_accum__.add(normal_log<propto__>(sigma_abs_x_cons, 0, 5));
            lp_accum__.add(normal_log<propto__>(sigma_reg_x_cons, 0, 5));
            lp_accum__.add(normal_log<propto__>(avg_particip, 0, 5));
            if (as_bool((primitive_value(logical_gt(model_type,2)) && primitive_value(logical_lt(model_type,8))))) {

                for (int i = 1; i <= (m - 2); ++i) {

                    lp_accum__.add(normal_log<propto__>((get_base1(steps_votes,(i + 1),"steps_votes",1) - get_base1(steps_votes,i,"steps_votes",1)), 0, 5));
                }
            } else {

                lp_accum__.add(normal_log<propto__>(steps_votes, 0, 5));
            }
            lp_accum__.add(normal_log<propto__>(B_int_free, 0, diff_reg_sd));
            lp_accum__.add(normal_log<propto__>(A_int_free, 0, diff_abs_sd));
            for (int b = 1; b <= num_bills; ++b) {

                lp_accum__.add(normal_log<propto__>(get_base1(steps_votes_grm,b,"steps_votes_grm",1), 0, 5));
            }
            for (int t = 1; t <= T; ++t) {
                lp_accum__.add(normal_log<propto__>(get_base1(restrict_ord,t,"restrict_ord",1), 0, 5));
            }
            if (as_bool(logical_eq(constrain_par,1))) {

                if (as_bool(logical_eq(constraint_type,1))) {

                    if (as_bool((primitive_value((primitive_value((primitive_value(logical_eq(hier_type,1)) || primitive_value(logical_eq(hier_type,4)))) || primitive_value(logical_eq(hier_type,5)))) || primitive_value(logical_eq(hier_type,7))))) {

                        lp_accum__.add(normal_log<propto__>(get_base1(restrict_low,1,"restrict_low",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_min_max(((num_legis - num_constrain_l) + 1), num_legis), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x_cons), restrict_sd));
                        lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_min_max(1, (num_legis - num_constrain_l)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                        if (as_bool(logical_gt(T,1))) {

                            for (int t = 2; t <= T; ++t) {

                                lp_accum__.add(normal_log<propto__>(get_base1(restrict_low,t,"restrict_low",1), add(get_base1(restrict_low,(t - 1),"restrict_low",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_min_max(((num_legis - num_constrain_l) + 1), num_legis), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x_cons)), restrict_sd));
                                lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_min_max(1, (num_legis - num_constrain_l)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                            }
                        }
                        if (as_bool(logical_eq(hier_type,1))) {

                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                        } else if (as_bool(logical_eq(hier_type,4))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(srx_pred,sigma_reg_x), 10));
                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                        } else if (as_bool(logical_eq(hier_type,5))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(sax_pred,sigma_abs_x), 10));
                        } else if (as_bool(logical_eq(hier_type,7))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(srx_pred,sigma_reg_x), 10));
                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(sax_pred,sigma_abs_x), 10));
                        }
                    } else {

                        lp_accum__.add(normal_log<propto__>(get_base1(restrict_low,1,"restrict_low",1), 0, restrict_sd));
                        lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                        if (as_bool(logical_gt(T,1))) {

                            for (int t = 2; t <= T; ++t) {

                                lp_accum__.add(normal_log<propto__>(get_base1(restrict_low,t,"restrict_low",1), get_base1(restrict_low,(t - 1),"restrict_low",1), restrict_sd));
                                lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                            }
                        }
                        if (as_bool(logical_eq(hier_type,2))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(srx_pred,sigma_reg_x), 10));
                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                        } else if (as_bool(logical_eq(hier_type,3))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(sax_pred,sigma_abs_x), 10));
                        } else if (as_bool(logical_eq(hier_type,6))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(srx_pred,sigma_reg_x), 10));
                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(sax_pred,sigma_abs_x), 10));
                        } else if (as_bool(logical_eq(hier_type,8))) {

                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                        }
                    }
                } else if (as_bool(logical_eq(constraint_type,2))) {

                    if (as_bool((primitive_value((primitive_value((primitive_value(logical_eq(hier_type,1)) || primitive_value(logical_eq(hier_type,4)))) || primitive_value(logical_eq(hier_type,5)))) || primitive_value(logical_eq(hier_type,7))))) {

                        lp_accum__.add(normal_log<propto__>(get_base1(restrict_high,1,"restrict_high",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_min_max(((num_legis - num_constrain_l) + 1), num_legis), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x_cons), restrict_sd));
                        lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_min_max(1, (num_legis - (2 * num_constrain_l))), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                        if (as_bool(logical_gt(T,1))) {

                            for (int t = 2; t <= T; ++t) {

                                lp_accum__.add(normal_log<propto__>(get_base1(restrict_high,t,"restrict_high",1), add(get_base1(restrict_high,(t - 1),"restrict_high",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_min_max(((num_legis - num_constrain_l) + 1), num_legis), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x_cons)), restrict_sd));
                                lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_min_max(1, (num_legis - num_constrain_l)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                            }
                        }
                        if (as_bool(logical_eq(hier_type,1))) {

                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                        } else if (as_bool(logical_eq(hier_type,4))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(srx_pred,sigma_reg_x), 10));
                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                        } else if (as_bool(logical_eq(hier_type,5))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(sax_pred,sigma_abs_x), 10));
                        } else if (as_bool(logical_eq(hier_type,7))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(srx_pred,sigma_reg_x), 10));
                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(sax_pred,sigma_abs_x), 10));
                        }
                    } else {

                        lp_accum__.add(normal_log<propto__>(get_base1(restrict_high,1,"restrict_high",1), 0, restrict_sd));
                        lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                        if (as_bool(logical_gt(T,1))) {

                            for (int t = 2; t <= T; ++t) {

                                lp_accum__.add(normal_log<propto__>(get_base1(restrict_high,t,"restrict_high",1), get_base1(restrict_high,(t - 1),"restrict_high",1), restrict_sd));
                                lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                            }
                        }
                        if (as_bool(logical_eq(hier_type,2))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(srx_pred,sigma_reg_x), 10));
                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                        } else if (as_bool(logical_eq(hier_type,3))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(sax_pred,sigma_abs_x), 10));
                        } else if (as_bool(logical_eq(hier_type,6))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(srx_pred,sigma_reg_x), 10));
                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(sax_pred,sigma_abs_x), 10));
                        } else if (as_bool(logical_eq(hier_type,8))) {

                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                        }
                    }
                } else if (as_bool(logical_eq(constraint_type,3))) {

                    if (as_bool((primitive_value((primitive_value((primitive_value(logical_eq(hier_type,1)) || primitive_value(logical_eq(hier_type,4)))) || primitive_value(logical_eq(hier_type,5)))) || primitive_value(logical_eq(hier_type,7))))) {

                        lp_accum__.add(normal_log<propto__>(get_base1(restrict_high,1,"restrict_high",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_min_max(((num_legis - (2 * num_constrain_l)) + 1), (num_legis - num_constrain_l)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x_cons), restrict_sd));
                        lp_accum__.add(normal_log<propto__>(get_base1(restrict_low,1,"restrict_low",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_min_max(((num_legis - num_constrain_l) + 1), num_legis), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x_cons), restrict_sd));
                        lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_min_max(1, (num_legis - num_constrain_l)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                        if (as_bool(logical_gt(T,1))) {

                            for (int t = 2; t <= T; ++t) {

                                lp_accum__.add(normal_log<propto__>(get_base1(restrict_high,t,"restrict_high",1), add(get_base1(restrict_high,(t - 1),"restrict_high",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_min_max(((num_legis - (2 * num_constrain_l)) + 1), (num_legis - num_constrain_l)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x_cons)), restrict_sd));
                                lp_accum__.add(normal_log<propto__>(get_base1(restrict_low,t,"restrict_low",1), add(get_base1(restrict_high,(t - 1),"restrict_high",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_min_max(((num_legis - num_constrain_l) + 1), num_legis), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x_cons)), restrict_sd));
                                lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_min_max(1, (num_legis - num_constrain_l)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                            }
                        }
                        if (as_bool(logical_eq(hier_type,1))) {

                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                        } else if (as_bool(logical_eq(hier_type,4))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(srx_pred,sigma_reg_x), 10));
                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                        } else if (as_bool(logical_eq(hier_type,5))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(sax_pred,sigma_abs_x), 10));
                        } else if (as_bool(logical_eq(hier_type,7))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(srx_pred,sigma_reg_x), 10));
                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(sax_pred,sigma_abs_x), 10));
                        }
                    } else {

                        lp_accum__.add(normal_log<propto__>(get_base1(restrict_high,1,"restrict_high",1), 0, restrict_sd));
                        lp_accum__.add(normal_log<propto__>(get_base1(restrict_low,1,"restrict_low",1), 0, restrict_sd));
                        lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                        if (as_bool(logical_gt(T,1))) {

                            for (int t = 2; t <= T; ++t) {

                                lp_accum__.add(normal_log<propto__>(get_base1(restrict_high,t,"restrict_high",1), get_base1(restrict_high,(t - 1),"restrict_high",1), restrict_sd));
                                lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                            }
                        }
                        if (as_bool(logical_eq(hier_type,2))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(srx_pred,sigma_reg_x), 10));
                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                        } else if (as_bool(logical_eq(hier_type,3))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(sax_pred,sigma_abs_x), 10));
                        } else if (as_bool(logical_eq(hier_type,6))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(srx_pred,sigma_reg_x), 10));
                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(sax_pred,sigma_abs_x), 10));
                        } else if (as_bool(logical_eq(hier_type,8))) {

                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                        }
                    }
                } else if (as_bool(logical_eq(constraint_type,4))) {

                    if (as_bool((primitive_value((primitive_value((primitive_value(logical_eq(hier_type,1)) || primitive_value(logical_eq(hier_type,4)))) || primitive_value(logical_eq(hier_type,5)))) || primitive_value(logical_eq(hier_type,7))))) {

                        lp_accum__.add(normal_log<propto__>(get_base1(pinned_pars,1,"pinned_pars",1), pin_vals, 0.01));
                        lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_min_max(1, (num_legis - num_constrain_l)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                        if (as_bool(logical_gt(T,1))) {

                            for (int t = 2; t <= T; ++t) {

                                lp_accum__.add(normal_log<propto__>(get_base1(pinned_pars,t,"pinned_pars",1), pin_vals, 0.01));
                                lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_min_max(1, (num_legis - num_constrain_l)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                            }
                        }
                        if (as_bool(logical_eq(hier_type,1))) {

                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                        } else if (as_bool(logical_eq(hier_type,4))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(srx_pred,sigma_reg_x), 10));
                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                        } else if (as_bool(logical_eq(hier_type,5))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(sax_pred,sigma_abs_x), 10));
                        } else if (as_bool(logical_eq(hier_type,7))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(srx_pred,sigma_reg_x), 10));
                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(sax_pred,sigma_abs_x), 10));
                        }
                    } else {

                        lp_accum__.add(normal_log<propto__>(get_base1(pinned_pars,1,"pinned_pars",1), pin_vals, 0.01));
                        lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                        if (as_bool(logical_gt(T,1))) {

                            for (int t = 2; t <= T; ++t) {

                                lp_accum__.add(normal_log<propto__>(get_base1(pinned_pars,t,"pinned_pars",1), pin_vals, 0.01));
                                lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                            }
                        }
                        if (as_bool(logical_eq(hier_type,2))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(srx_pred,sigma_reg_x), 10));
                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                        } else if (as_bool(logical_eq(hier_type,3))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(sax_pred,sigma_abs_x), 10));
                        } else if (as_bool(logical_eq(hier_type,6))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(srx_pred,sigma_reg_x), 10));
                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(sax_pred,sigma_abs_x), 10));
                        } else if (as_bool(logical_eq(hier_type,8))) {

                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                        }
                    }
                }
            } else if (as_bool(logical_eq(constrain_par,2))) {

                if (as_bool(logical_eq(constraint_type,1))) {

                    if (as_bool((primitive_value((primitive_value((primitive_value(logical_eq(hier_type,3)) || primitive_value(logical_eq(hier_type,5)))) || primitive_value(logical_eq(hier_type,6)))) || primitive_value(logical_eq(hier_type,7))))) {

                        lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(stan::model::rvalue(sax_pred, stan::model::cons_list(stan::model::index_uni((num_bills - num_constrain_sa)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "sax_pred"),sigma_abs_x), 10));
                        lp_accum__.add(normal_log<propto__>(get_base1(restrict_low,1,"restrict_low",1), multiply(stan::model::rvalue(sax_pred, stan::model::cons_list(stan::model::index_min_max(((num_bills - num_constrain_sa) + 1), num_legis), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "sax_pred"),sigma_abs_x_cons), restrict_sd));
                        if (as_bool(logical_eq(hier_type,3))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                                }
                            }
                        } else if (as_bool(logical_eq(hier_type,5))) {

                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                                }
                            }
                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                        } else if (as_bool(logical_eq(hier_type,6))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(srx_pred,sigma_reg_x), 10));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                                }
                            }
                        } else if (as_bool(logical_eq(hier_type,7))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(srx_pred,sigma_reg_x), 10));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                                }
                            }
                        }
                    } else {

                        lp_accum__.add(normal_log<propto__>(get_base1(restrict_low,1,"restrict_low",1), 0, restrict_sd));
                        lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                        if (as_bool(logical_eq(hier_type,1))) {

                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                                }
                            }
                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                        } else if (as_bool(logical_eq(hier_type,2))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(srx_pred,sigma_reg_x), 10));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                                }
                            }
                        } else if (as_bool(logical_eq(hier_type,4))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(srx_pred,sigma_reg_x), 10));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                                }
                            }
                        } else if (as_bool(logical_eq(hier_type,8))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                                }
                            }
                        }
                    }
                } else if (as_bool(logical_eq(constraint_type,2))) {

                    if (as_bool((primitive_value((primitive_value((primitive_value(logical_eq(hier_type,3)) || primitive_value(logical_eq(hier_type,5)))) || primitive_value(logical_eq(hier_type,6)))) || primitive_value(logical_eq(hier_type,7))))) {

                        lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(stan::model::rvalue(sax_pred, stan::model::cons_list(stan::model::index_uni((num_bills - num_constrain_sa)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "sax_pred"),sigma_abs_x), 10));
                        lp_accum__.add(normal_log<propto__>(get_base1(restrict_high,1,"restrict_high",1), multiply(stan::model::rvalue(sax_pred, stan::model::cons_list(stan::model::index_min_max(((num_bills - num_constrain_sa) + 1), num_bills), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "sax_pred"),sigma_abs_x_cons), restrict_sd));
                        if (as_bool(logical_eq(hier_type,3))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                                }
                            }
                        } else if (as_bool(logical_eq(hier_type,5))) {

                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                                }
                            }
                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                        } else if (as_bool(logical_eq(hier_type,6))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(srx_pred,sigma_reg_x), 10));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                                }
                            }
                        } else if (as_bool(logical_eq(hier_type,7))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(srx_pred,sigma_reg_x), 10));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                                }
                            }
                        }
                    } else {

                        lp_accum__.add(normal_log<propto__>(get_base1(restrict_high,1,"restrict_high",1), 0, restrict_sd));
                        lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                        if (as_bool(logical_eq(hier_type,1))) {

                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                                }
                            }
                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                        } else if (as_bool(logical_eq(hier_type,2))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(srx_pred,sigma_reg_x), 10));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                                }
                            }
                        } else if (as_bool(logical_eq(hier_type,4))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(srx_pred,sigma_reg_x), 10));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                                }
                            }
                        } else if (as_bool(logical_eq(hier_type,8))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                                }
                            }
                        }
                    }
                } else if (as_bool(logical_eq(constraint_type,3))) {

                    if (as_bool((primitive_value((primitive_value((primitive_value(logical_eq(hier_type,3)) || primitive_value(logical_eq(hier_type,5)))) || primitive_value(logical_eq(hier_type,6)))) || primitive_value(logical_eq(hier_type,7))))) {

                        lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(stan::model::rvalue(sax_pred, stan::model::cons_list(stan::model::index_uni((num_bills - num_constrain_sa)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "sax_pred"),sigma_abs_x), 10));
                        lp_accum__.add(normal_log<propto__>(get_base1(restrict_high,1,"restrict_high",1), multiply(stan::model::rvalue(sax_pred, stan::model::cons_list(stan::model::index_min_max(((num_bills - (2 * num_constrain_sa)) + 1), (num_bills - num_constrain_sa)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "sax_pred"),sigma_abs_x_cons), restrict_sd));
                        lp_accum__.add(normal_log<propto__>(get_base1(restrict_low,1,"restrict_low",1), multiply(stan::model::rvalue(sax_pred, stan::model::cons_list(stan::model::index_min_max(((num_bills - num_constrain_sa) + 1), num_bills), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "sax_pred"),sigma_abs_x_cons), restrict_sd));
                        if (as_bool(logical_eq(hier_type,3))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                                }
                            }
                        } else if (as_bool(logical_eq(hier_type,5))) {

                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                                }
                            }
                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                        } else if (as_bool(logical_eq(hier_type,6))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(srx_pred,sigma_reg_x), 10));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                                }
                            }
                        } else if (as_bool(logical_eq(hier_type,7))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(srx_pred,sigma_reg_x), 10));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                                }
                            }
                        }
                    } else {

                        lp_accum__.add(normal_log<propto__>(get_base1(restrict_high,1,"restrict_high",1), 0, restrict_sd));
                        lp_accum__.add(normal_log<propto__>(get_base1(restrict_low,1,"restrict_low",1), 0, restrict_sd));
                        lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                        if (as_bool(logical_eq(hier_type,1))) {

                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                                }
                            }
                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                        } else if (as_bool(logical_eq(hier_type,2))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(srx_pred,sigma_reg_x), 10));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                                }
                            }
                        } else if (as_bool(logical_eq(hier_type,4))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(srx_pred,sigma_reg_x), 10));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                                }
                            }
                        } else if (as_bool(logical_eq(hier_type,8))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                                }
                            }
                        }
                    }
                } else if (as_bool(logical_eq(constraint_type,4))) {

                    if (as_bool((primitive_value((primitive_value((primitive_value(logical_eq(hier_type,3)) || primitive_value(logical_eq(hier_type,5)))) || primitive_value(logical_eq(hier_type,6)))) || primitive_value(logical_eq(hier_type,7))))) {

                        lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(stan::model::rvalue(sax_pred, stan::model::cons_list(stan::model::index_uni((num_bills - num_constrain_sa)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "sax_pred"),sigma_abs_x), 10));
                        lp_accum__.add(normal_log<propto__>(get_base1(pinned_pars,1,"pinned_pars",1), pin_vals, 0.01));
                        if (as_bool(logical_eq(hier_type,3))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                                }
                            }
                        } else if (as_bool(logical_eq(hier_type,5))) {

                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                                }
                            }
                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                        } else if (as_bool(logical_eq(hier_type,6))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(srx_pred,sigma_reg_x), 10));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                                }
                            }
                        } else if (as_bool(logical_eq(hier_type,7))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(srx_pred,sigma_reg_x), 10));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                                }
                            }
                        }
                    } else {

                        lp_accum__.add(normal_log<propto__>(get_base1(pinned_pars,1,"pinned_pars",1), pin_vals, 0.01));
                        lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                        if (as_bool(logical_eq(hier_type,1))) {

                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                                }
                            }
                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                        } else if (as_bool(logical_eq(hier_type,2))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(srx_pred,sigma_reg_x), 10));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                                }
                            }
                        } else if (as_bool(logical_eq(hier_type,4))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(srx_pred,sigma_reg_x), 10));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                                }
                            }
                        } else if (as_bool(logical_eq(hier_type,8))) {

                            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                                }
                            }
                        }
                    }
                }
            } else if (as_bool(logical_eq(constrain_par,3))) {

                if (as_bool(logical_eq(constraint_type,1))) {

                    if (as_bool((primitive_value((primitive_value((primitive_value(logical_eq(hier_type,3)) || primitive_value(logical_eq(hier_type,5)))) || primitive_value(logical_eq(hier_type,6)))) || primitive_value(logical_eq(hier_type,7))))) {

                        lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(stan::model::rvalue(srx_pred, stan::model::cons_list(stan::model::index_uni((num_bills - num_constrain_sr)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "srx_pred"),sigma_reg_x), 10));
                        lp_accum__.add(normal_log<propto__>(get_base1(restrict_high,1,"restrict_high",1), multiply(stan::model::rvalue(srx_pred, stan::model::cons_list(stan::model::index_min_max(((num_bills - num_constrain_sr) + 1), num_bills), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "srx_pred"),sigma_reg_x_cons), restrict_sd));
                        if (as_bool(logical_eq(hier_type,2))) {

                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                                }
                            }
                        } else if (as_bool(logical_eq(hier_type,4))) {

                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                                }
                            }
                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                        } else if (as_bool(logical_eq(hier_type,6))) {

                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(sax_pred,sigma_abs_x), 10));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                                }
                            }
                        } else if (as_bool(logical_eq(hier_type,7))) {

                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(sax_pred,sigma_abs_x), 10));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                                }
                            }
                        }
                    } else {

                        lp_accum__.add(normal_log<propto__>(get_base1(restrict_high,1,"restrict_high",1), 0, restrict_sd));
                        lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                        if (as_bool(logical_eq(hier_type,1))) {

                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                                }
                            }
                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                        } else if (as_bool(logical_eq(hier_type,3))) {

                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(sax_pred,sigma_abs_x), 10));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                                }
                            }
                        } else if (as_bool(logical_eq(hier_type,5))) {

                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(sax_pred,sigma_abs_x), 10));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                                }
                            }
                        } else if (as_bool(logical_eq(hier_type,8))) {

                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                                }
                            }
                        }
                    }
                } else if (as_bool(logical_eq(constraint_type,2))) {

                    if (as_bool((primitive_value((primitive_value((primitive_value(logical_eq(hier_type,3)) || primitive_value(logical_eq(hier_type,5)))) || primitive_value(logical_eq(hier_type,6)))) || primitive_value(logical_eq(hier_type,7))))) {

                        lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(stan::model::rvalue(srx_pred, stan::model::cons_list(stan::model::index_uni((num_bills - num_constrain_sr)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "srx_pred"),sigma_reg_x), 10));
                        lp_accum__.add(normal_log<propto__>(get_base1(restrict_high,1,"restrict_high",1), multiply(stan::model::rvalue(srx_pred, stan::model::cons_list(stan::model::index_min_max(((num_bills - num_constrain_sr) + 1), num_bills), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "srx_pred"),sigma_reg_x_cons), restrict_sd));
                        if (as_bool(logical_eq(hier_type,2))) {

                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                                }
                            }
                        } else if (as_bool(logical_eq(hier_type,4))) {

                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                                }
                            }
                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                        } else if (as_bool(logical_eq(hier_type,6))) {

                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(sax_pred,sigma_abs_x), 10));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                                }
                            }
                        } else if (as_bool(logical_eq(hier_type,7))) {

                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(sax_pred,sigma_abs_x), 10));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                                }
                            }
                        }
                    } else {

                        lp_accum__.add(normal_log<propto__>(get_base1(restrict_high,1,"restrict_high",1), 0, restrict_sd));
                        lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                        if (as_bool(logical_eq(hier_type,1))) {

                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                                }
                            }
                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                        } else if (as_bool(logical_eq(hier_type,3))) {

                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(sax_pred,sigma_abs_x), 10));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                                }
                            }
                        } else if (as_bool(logical_eq(hier_type,5))) {

                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                                }
                            }
                        } else if (as_bool(logical_eq(hier_type,8))) {

                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                                }
                            }
                        }
                    }
                } else if (as_bool(logical_eq(constraint_type,3))) {

                    if (as_bool((primitive_value((primitive_value((primitive_value(logical_eq(hier_type,3)) || primitive_value(logical_eq(hier_type,5)))) || primitive_value(logical_eq(hier_type,6)))) || primitive_value(logical_eq(hier_type,7))))) {

                        lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(stan::model::rvalue(srx_pred, stan::model::cons_list(stan::model::index_uni((num_bills - num_constrain_sr)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "srx_pred"),sigma_reg_x), 10));
                        lp_accum__.add(normal_log<propto__>(get_base1(restrict_high,1,"restrict_high",1), multiply(stan::model::rvalue(srx_pred, stan::model::cons_list(stan::model::index_min_max(((num_bills - (2 * num_constrain_sr)) + 1), (num_bills - num_constrain_sr)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "srx_pred"),sigma_reg_x_cons), restrict_sd));
                        lp_accum__.add(normal_log<propto__>(get_base1(restrict_low,1,"restrict_low",1), multiply(stan::model::rvalue(srx_pred, stan::model::cons_list(stan::model::index_min_max(((num_bills - num_constrain_sr) + 1), num_bills), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "srx_pred"),sigma_reg_x_cons), restrict_sd));
                        if (as_bool(logical_eq(hier_type,2))) {

                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                                }
                            }
                        } else if (as_bool(logical_eq(hier_type,4))) {

                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                                }
                            }
                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                        } else if (as_bool(logical_eq(hier_type,6))) {

                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(sax_pred,sigma_abs_x), 10));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                                }
                            }
                        } else if (as_bool(logical_eq(hier_type,7))) {

                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(sax_pred,sigma_abs_x), 10));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                                }
                            }
                        }
                    } else {

                        lp_accum__.add(normal_log<propto__>(get_base1(restrict_high,1,"restrict_high",1), 0, restrict_sd));
                        lp_accum__.add(normal_log<propto__>(get_base1(restrict_low,1,"restrict_low",1), 0, restrict_sd));
                        lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                        if (as_bool(logical_eq(hier_type,1))) {

                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                                }
                            }
                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                        } else if (as_bool(logical_eq(hier_type,3))) {

                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(sax_pred,sigma_abs_x), 10));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                                }
                            }
                        } else if (as_bool(logical_eq(hier_type,5))) {

                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(sax_pred,sigma_abs_x), 10));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                                }
                            }
                        } else if (as_bool(logical_eq(hier_type,8))) {

                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                                }
                            }
                        }
                    }
                } else if (as_bool(logical_eq(constraint_type,4))) {

                    if (as_bool((primitive_value((primitive_value((primitive_value(logical_eq(hier_type,3)) || primitive_value(logical_eq(hier_type,5)))) || primitive_value(logical_eq(hier_type,6)))) || primitive_value(logical_eq(hier_type,7))))) {

                        lp_accum__.add(normal_log<propto__>(sigma_reg_free, multiply(stan::model::rvalue(srx_pred, stan::model::cons_list(stan::model::index_uni((num_bills - num_constrain_sr)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "srx_pred"),sigma_reg_x), 10));
                        lp_accum__.add(normal_log<propto__>(get_base1(pinned_pars,1,"pinned_pars",1), pin_vals, 0.01));
                        if (as_bool(logical_eq(hier_type,2))) {

                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                                }
                            }
                        } else if (as_bool(logical_eq(hier_type,4))) {

                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                                }
                            }
                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                        } else if (as_bool(logical_eq(hier_type,6))) {

                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(sax_pred,sigma_abs_x), 10));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                                }
                            }
                        } else if (as_bool(logical_eq(hier_type,7))) {

                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(sax_pred,sigma_abs_x), 10));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                                }
                            }
                        }
                    } else {

                        lp_accum__.add(normal_log<propto__>(get_base1(pinned_pars,1,"pinned_pars",1), pin_vals, 0.01));
                        lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
                        if (as_bool(logical_eq(hier_type,1))) {

                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                                }
                            }
                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                        } else if (as_bool(logical_eq(hier_type,3))) {

                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(sax_pred,sigma_abs_x), 10));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                                }
                            }
                        } else if (as_bool(logical_eq(hier_type,5))) {

                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, multiply(sax_pred,sigma_abs_x), 10));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x), legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), add(get_base1(L_free,(t - 1),"L_free",1),multiply(stan::model::rvalue(legis_pred, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "legis_pred"),legis_x)), legis_sd));
                                }
                            }
                        } else if (as_bool(logical_eq(hier_type,8))) {

                            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
                            lp_accum__.add(normal_log<propto__>(get_base1(L_free,1,"L_free",1), 0, legis_sd));
                            if (as_bool(logical_gt(T,1))) {

                                for (int t = 2; t <= T; ++t) {

                                    lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), get_base1(L_free,(t - 1),"L_free",1), legis_sd));
                                }
                            }
                        }
                    }
                }
            }
            if (as_bool(logical_neq(constraint_type,4))) {

                for (int t = 1; t <= T; ++t) {

                    lp_accum__.add(normal_log<propto__>(get_base1(pinned_pars,t,"pinned_pars",1), 0, 1));
                }
            }
            if (as_bool((primitive_value(logical_neq(constraint_type,1)) || primitive_value(logical_neq(constraint_type,3))))) {

                for (int t = 1; t <= T; ++t) {

                    lp_accum__.add(normal_log<propto__>(get_base1(restrict_low,t,"restrict_low",1), 0, 1));
                }
            }
            if (as_bool((primitive_value(logical_eq(constraint_type,4)) || primitive_value(logical_eq(constraint_type,2))))) {

                for (int t = 1; t <= T; ++t) {

                    lp_accum__.add(normal_log<propto__>(get_base1(restrict_high,t,"restrict_high",1), 0, 1));
                }
            }
            if (as_bool(logical_eq(model_type,1))) {

                for (int n = 1; n <= N; ++n) {

                    stan::math::assign(get_base1_lhs(pi1,n,"pi1",1), ((get_base1(sigma_reg_full,get_base1(bb,n,"bb",1),"sigma_reg_full",1) * get_base1(get_base1(L_full,get_base1(time,n,"time",1),"L_full",1),get_base1(ll,n,"ll",1),"L_full",2)) - get_base1(B_int_full,get_base1(bb,n,"bb",1),"B_int_full",1)));
                }
                lp_accum__.add(bernoulli_logit_log<propto__>(Y_new, pi1));
            } else if (as_bool(logical_eq(model_type,2))) {

                for (int n = 1; n <= N; ++n) {

                    stan::math::assign(get_base1_lhs(pi1,n,"pi1",1), ((get_base1(sigma_reg_full,get_base1(bb,n,"bb",1),"sigma_reg_full",1) * get_base1(get_base1(L_full,get_base1(time,n,"time",1),"L_full",1),get_base1(ll,n,"ll",1),"L_full",2)) - get_base1(B_int_full,get_base1(bb,n,"bb",1),"B_int_full",1)));
                    stan::math::assign(get_base1_lhs(pi2,n,"pi2",1), ((get_base1(sigma_abs_full,get_base1(bb,n,"bb",1),"sigma_abs_full",1) * get_base1(get_base1(L_full,get_base1(time,n,"time",1),"L_full",1),get_base1(ll,n,"ll",1),"L_full",2)) - get_base1(A_int_full,get_base1(bb,n,"bb",1),"A_int_full",1)));
                    if (as_bool(logical_eq(get_base1(absence,n,"absence",1),1))) {

                        lp_accum__.add(bernoulli_logit_log<propto__>(1, get_base1(pi2,n,"pi2",1)));
                    } else {

                        lp_accum__.add(bernoulli_logit_log<propto__>(0, get_base1(pi2,n,"pi2",1)));
                        lp_accum__.add(bernoulli_logit_log<propto__>(get_base1(Y_new,n,"Y_new",1), get_base1(pi1,n,"pi1",1)));
                    }
                }
            } else if (as_bool(logical_eq(model_type,3))) {

                for (int n = 1; n <= N; ++n) {

                    stan::math::assign(get_base1_lhs(pi1,n,"pi1",1), ((get_base1(sigma_reg_full,get_base1(bb,n,"bb",1),"sigma_reg_full",1) * get_base1(get_base1(L_full,get_base1(time,n,"time",1),"L_full",1),get_base1(ll,n,"ll",1),"L_full",2)) - get_base1(B_int_full,get_base1(bb,n,"bb",1),"B_int_full",1)));
                    lp_accum__.add(ordered_logistic_log<propto__>(get_base1(Y,n,"Y",1), get_base1(pi1,n,"pi1",1), steps_votes));
                }
            } else if (as_bool(logical_eq(model_type,4))) {

                for (int n = 1; n <= N; ++n) {

                    stan::math::assign(get_base1_lhs(pi1,n,"pi1",1), ((get_base1(sigma_reg_full,get_base1(bb,n,"bb",1),"sigma_reg_full",1) * get_base1(get_base1(L_full,get_base1(time,n,"time",1),"L_full",1),get_base1(ll,n,"ll",1),"L_full",2)) - get_base1(B_int_full,get_base1(bb,n,"bb",1),"B_int_full",1)));
                    stan::math::assign(get_base1_lhs(pi2,n,"pi2",1), ((get_base1(sigma_abs_full,get_base1(bb,n,"bb",1),"sigma_abs_full",1) * get_base1(get_base1(L_full,get_base1(time,n,"time",1),"L_full",1),get_base1(ll,n,"ll",1),"L_full",2)) - get_base1(A_int_full,get_base1(bb,n,"bb",1),"A_int_full",1)));
                    if (as_bool(logical_eq(get_base1(absence,n,"absence",1),1))) {

                        lp_accum__.add(bernoulli_logit_log<propto__>(1, get_base1(pi2,n,"pi2",1)));
                    } else {

                        lp_accum__.add(bernoulli_logit_log<propto__>(0, get_base1(pi2,n,"pi2",1)));
                        lp_accum__.add(ordered_logistic_log<propto__>(get_base1(Y,n,"Y",1), get_base1(pi1,n,"pi1",1), steps_votes));
                    }
                }
            } else if (as_bool(logical_eq(model_type,5))) {

                for (int n = 1; n <= N; ++n) {

                    stan::math::assign(get_base1_lhs(pi1,n,"pi1",1), ((get_base1(sigma_reg_full,get_base1(bb,n,"bb",1),"sigma_reg_full",1) * get_base1(get_base1(L_full,get_base1(time,n,"time",1),"L_full",1),get_base1(ll,n,"ll",1),"L_full",2)) - get_base1(B_int_full,get_base1(bb,n,"bb",1),"B_int_full",1)));
                    lp_accum__.add(ordered_logistic_log<propto__>(get_base1(Y,n,"Y",1), get_base1(pi1,n,"pi1",1), get_base1(steps_votes_grm,get_base1(bb,n,"bb",1),"steps_votes_grm",1)));
                }
            } else if (as_bool(logical_eq(model_type,6))) {

                for (int n = 1; n <= N; ++n) {

                    stan::math::assign(get_base1_lhs(pi1,n,"pi1",1), ((get_base1(sigma_reg_full,get_base1(bb,n,"bb",1),"sigma_reg_full",1) * get_base1(get_base1(L_full,get_base1(time,n,"time",1),"L_full",1),get_base1(ll,n,"ll",1),"L_full",2)) - get_base1(B_int_full,get_base1(bb,n,"bb",1),"B_int_full",1)));
                    stan::math::assign(get_base1_lhs(pi2,n,"pi2",1), ((get_base1(sigma_abs_full,get_base1(bb,n,"bb",1),"sigma_abs_full",1) * get_base1(get_base1(L_full,get_base1(time,n,"time",1),"L_full",1),get_base1(ll,n,"ll",1),"L_full",2)) - get_base1(A_int_full,get_base1(bb,n,"bb",1),"A_int_full",1)));
                    if (as_bool(logical_eq(get_base1(absence,n,"absence",1),1))) {

                        lp_accum__.add(bernoulli_logit_log<propto__>(1, get_base1(pi2,n,"pi2",1)));
                    } else {

                        lp_accum__.add(bernoulli_logit_log<propto__>(0, get_base1(pi2,n,"pi2",1)));
                        lp_accum__.add(ordered_logistic_log<propto__>(get_base1(Y,n,"Y",1), get_base1(pi1,n,"pi1",1), get_base1(steps_votes_grm,get_base1(bb,n,"bb",1),"steps_votes_grm",1)));
                    }
                }
            } else if (as_bool(logical_eq(model_type,7))) {

                for (int n = 1; n <= N; ++n) {

                    stan::math::assign(get_base1_lhs(pi1,n,"pi1",1), ((get_base1(sigma_reg_full,get_base1(bb,n,"bb",1),"sigma_reg_full",1) * get_base1(get_base1(L_full,get_base1(time,n,"time",1),"L_full",1),get_base1(ll,n,"ll",1),"L_full",2)) - get_base1(B_int_full,get_base1(bb,n,"bb",1),"B_int_full",1)));
                    stan::math::assign(get_base1_lhs(pi2,n,"pi2",1), ((get_base1(sigma_abs_full,get_base1(bb,n,"bb",1),"sigma_abs_full",1) * get_base1(get_base1(L_full,get_base1(time,n,"time",1),"L_full",1),get_base1(ll,n,"ll",1),"L_full",2)) - get_base1(A_int_full,get_base1(bb,n,"bb",1),"A_int_full",1)));
                    if (as_bool(logical_eq(get_base1(absence,n,"absence",1),1))) {

                        lp_accum__.add(bernoulli_logit_log<propto__>(1, get_base1(pi2,n,"pi2",1)));
                    } else {

                        lp_accum__.add(bernoulli_logit_log<propto__>(0, get_base1(pi2,n,"pi2",1)));
                        lp_accum__.add(poisson_log<propto__>(get_base1(Y,n,"Y",1), get_base1(pi1,n,"pi1",1)));
                    }
                }
            }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("sigma_abs_free");
        names__.push_back("L_free");
        names__.push_back("sigma_reg_free");
        names__.push_back("restrict_low");
        names__.push_back("restrict_high");
        names__.push_back("pinned_pars");
        names__.push_back("legis_x");
        names__.push_back("sigma_reg_x");
        names__.push_back("sigma_abs_x");
        names__.push_back("legis_x_cons");
        names__.push_back("sigma_reg_x_cons");
        names__.push_back("sigma_abs_x_cons");
        names__.push_back("B_int_free");
        names__.push_back("A_int_free");
        names__.push_back("steps_votes");
        names__.push_back("steps_votes_grm");
        names__.push_back("restrict_ord");
        names__.push_back("avg_particip");
        names__.push_back("L_full");
        names__.push_back("sigma_abs_full");
        names__.push_back("sigma_reg_full");
        names__.push_back("B_int_full");
        names__.push_back("A_int_full");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back((num_bills - num_constrain_sa));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back((num_legis - num_constrain_l));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((num_bills - num_constrain_sr));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(num_fix_low);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(num_fix_high);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(num_fix_high);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(LX);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SRX);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SAX);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(LX);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SRX);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SAX);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_bills);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_bills);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((m - 1));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_bills);
        dims__.push_back((m - 1));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back((num_fix_low + num_fix_high));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(num_legis);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_bills);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_bills);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_bills);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_bills);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_irt_standard_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d sigma_abs_free = in__.vector_constrain((num_bills - num_constrain_sa));
        vector<vector_d> L_free;
        size_t dim_L_free_0__ = T;
        for (size_t k_0__ = 0; k_0__ < dim_L_free_0__; ++k_0__) {
            L_free.push_back(in__.vector_constrain((num_legis - num_constrain_l)));
        }
        vector_d sigma_reg_free = in__.vector_constrain((num_bills - num_constrain_sr));
        vector<vector_d> restrict_low;
        size_t dim_restrict_low_0__ = T;
        for (size_t k_0__ = 0; k_0__ < dim_restrict_low_0__; ++k_0__) {
            restrict_low.push_back(in__.vector_ub_constrain(restrict_low_bar,num_fix_low));
        }
        vector<vector_d> restrict_high;
        size_t dim_restrict_high_0__ = T;
        for (size_t k_0__ = 0; k_0__ < dim_restrict_high_0__; ++k_0__) {
            restrict_high.push_back(in__.vector_lb_constrain(restrict_high_bar,num_fix_high));
        }
        vector<vector_d> pinned_pars;
        size_t dim_pinned_pars_0__ = T;
        for (size_t k_0__ = 0; k_0__ < dim_pinned_pars_0__; ++k_0__) {
            pinned_pars.push_back(in__.vector_constrain(num_fix_high));
        }
        vector_d legis_x = in__.vector_constrain(LX);
        vector_d sigma_reg_x = in__.vector_constrain(SRX);
        vector_d sigma_abs_x = in__.vector_constrain(SAX);
        vector_d legis_x_cons = in__.vector_constrain(LX);
        vector_d sigma_reg_x_cons = in__.vector_constrain(SRX);
        vector_d sigma_abs_x_cons = in__.vector_constrain(SAX);
        vector_d B_int_free = in__.vector_constrain(num_bills);
        vector_d A_int_free = in__.vector_constrain(num_bills);
        vector_d steps_votes = in__.ordered_constrain((m - 1));
        vector<vector_d> steps_votes_grm;
        size_t dim_steps_votes_grm_0__ = num_bills;
        for (size_t k_0__ = 0; k_0__ < dim_steps_votes_grm_0__; ++k_0__) {
            steps_votes_grm.push_back(in__.ordered_constrain((m - 1)));
        }
        vector<vector_d> restrict_ord;
        size_t dim_restrict_ord_0__ = T;
        for (size_t k_0__ = 0; k_0__ < dim_restrict_ord_0__; ++k_0__) {
            restrict_ord.push_back(in__.ordered_constrain((num_fix_low + num_fix_high)));
        }
        double avg_particip = in__.scalar_constrain();
            for (int k_0__ = 0; k_0__ < (num_bills - num_constrain_sa); ++k_0__) {
            vars__.push_back(sigma_abs_free[k_0__]);
            }
            for (int k_1__ = 0; k_1__ < (num_legis - num_constrain_l); ++k_1__) {
                for (int k_0__ = 0; k_0__ < T; ++k_0__) {
                vars__.push_back(L_free[k_0__][k_1__]);
                }
            }
            for (int k_0__ = 0; k_0__ < (num_bills - num_constrain_sr); ++k_0__) {
            vars__.push_back(sigma_reg_free[k_0__]);
            }
            for (int k_1__ = 0; k_1__ < num_fix_low; ++k_1__) {
                for (int k_0__ = 0; k_0__ < T; ++k_0__) {
                vars__.push_back(restrict_low[k_0__][k_1__]);
                }
            }
            for (int k_1__ = 0; k_1__ < num_fix_high; ++k_1__) {
                for (int k_0__ = 0; k_0__ < T; ++k_0__) {
                vars__.push_back(restrict_high[k_0__][k_1__]);
                }
            }
            for (int k_1__ = 0; k_1__ < num_fix_high; ++k_1__) {
                for (int k_0__ = 0; k_0__ < T; ++k_0__) {
                vars__.push_back(pinned_pars[k_0__][k_1__]);
                }
            }
            for (int k_0__ = 0; k_0__ < LX; ++k_0__) {
            vars__.push_back(legis_x[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < SRX; ++k_0__) {
            vars__.push_back(sigma_reg_x[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < SAX; ++k_0__) {
            vars__.push_back(sigma_abs_x[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < LX; ++k_0__) {
            vars__.push_back(legis_x_cons[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < SRX; ++k_0__) {
            vars__.push_back(sigma_reg_x_cons[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < SAX; ++k_0__) {
            vars__.push_back(sigma_abs_x_cons[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < num_bills; ++k_0__) {
            vars__.push_back(B_int_free[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < num_bills; ++k_0__) {
            vars__.push_back(A_int_free[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < (m - 1); ++k_0__) {
            vars__.push_back(steps_votes[k_0__]);
            }
            for (int k_1__ = 0; k_1__ < (m - 1); ++k_1__) {
                for (int k_0__ = 0; k_0__ < num_bills; ++k_0__) {
                vars__.push_back(steps_votes_grm[k_0__][k_1__]);
                }
            }
            for (int k_1__ = 0; k_1__ < (num_fix_low + num_fix_high); ++k_1__) {
                for (int k_0__ = 0; k_0__ < T; ++k_0__) {
                vars__.push_back(restrict_ord[k_0__][k_1__]);
                }
            }
        vars__.push_back(avg_particip);

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            validate_non_negative_index("L_full", "num_legis", num_legis);
            validate_non_negative_index("L_full", "T", T);
            vector<vector_d> L_full(T, (vector_d(static_cast<Eigen::VectorXd::Index>(num_legis))));
            stan::math::initialize(L_full, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(L_full,DUMMY_VAR__);
            validate_non_negative_index("sigma_abs_full", "num_bills", num_bills);
            vector_d sigma_abs_full(static_cast<Eigen::VectorXd::Index>(num_bills));
            (void) sigma_abs_full;  // dummy to suppress unused var warning

            stan::math::initialize(sigma_abs_full, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(sigma_abs_full,DUMMY_VAR__);
            validate_non_negative_index("sigma_reg_full", "num_bills", num_bills);
            vector_d sigma_reg_full(static_cast<Eigen::VectorXd::Index>(num_bills));
            (void) sigma_reg_full;  // dummy to suppress unused var warning

            stan::math::initialize(sigma_reg_full, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(sigma_reg_full,DUMMY_VAR__);
            validate_non_negative_index("B_int_full", "num_bills", num_bills);
            vector_d B_int_full(static_cast<Eigen::VectorXd::Index>(num_bills));
            (void) B_int_full;  // dummy to suppress unused var warning

            stan::math::initialize(B_int_full, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(B_int_full,DUMMY_VAR__);
            validate_non_negative_index("A_int_full", "num_bills", num_bills);
            vector_d A_int_full(static_cast<Eigen::VectorXd::Index>(num_bills));
            (void) A_int_full;  // dummy to suppress unused var warning

            stan::math::initialize(A_int_full, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(A_int_full,DUMMY_VAR__);


            stan::math::assign(B_int_full, B_int_free);
            stan::math::assign(A_int_full, A_int_free);
            if (as_bool(logical_eq(constrain_par,1))) {

                if (as_bool(logical_eq(constraint_type,1))) {

                    for (int t = 1; t <= T; ++t) {

                        stan::math::assign(get_base1_lhs(L_full,t,"L_full",1), append_row(get_base1(L_free,t,"L_free",1),get_base1(restrict_low,t,"restrict_low",1)));
                    }
                } else if (as_bool(logical_eq(constraint_type,2))) {

                    for (int t = 1; t <= T; ++t) {

                        stan::math::assign(get_base1_lhs(L_full,t,"L_full",1), append_row(get_base1(L_free,t,"L_free",1),get_base1(restrict_high,t,"restrict_high",1)));
                    }
                } else if (as_bool(logical_eq(constraint_type,3))) {

                    for (int t = 1; t <= T; ++t) {

                        stan::math::assign(get_base1_lhs(L_full,t,"L_full",1), append_row(get_base1(L_free,t,"L_free",1),append_row(get_base1(restrict_high,t,"restrict_high",1),get_base1(restrict_low,t,"restrict_low",1))));
                    }
                } else if (as_bool(logical_eq(constraint_type,4))) {

                    for (int t = 1; t <= T; ++t) {

                        stan::math::assign(get_base1_lhs(L_full,t,"L_full",1), append_row(get_base1(L_free,t,"L_free",1),get_base1(pinned_pars,t,"pinned_pars",1)));
                    }
                }
                stan::math::assign(sigma_abs_full, sigma_abs_free);
                stan::math::assign(sigma_reg_full, sigma_reg_free);
            } else if (as_bool(logical_eq(constrain_par,2))) {

                if (as_bool(logical_eq(constraint_type,1))) {

                    stan::math::assign(sigma_abs_full, append_row(sigma_abs_free,get_base1(restrict_low,1,"restrict_low",1)));
                } else if (as_bool(logical_eq(constraint_type,2))) {

                    stan::math::assign(sigma_abs_full, append_row(sigma_abs_free,get_base1(restrict_high,1,"restrict_high",1)));
                } else if (as_bool(logical_eq(constraint_type,3))) {

                    stan::math::assign(sigma_abs_full, append_row(sigma_abs_free,append_row(get_base1(restrict_high,1,"restrict_high",1),get_base1(restrict_low,1,"restrict_low",1))));
                } else if (as_bool(logical_eq(constraint_type,4))) {

                    stan::math::assign(sigma_abs_full, append_row(sigma_abs_free,get_base1(pinned_pars,1,"pinned_pars",1)));
                }
                stan::math::assign(L_full, L_free);
                stan::math::assign(sigma_reg_full, sigma_reg_free);
            } else if (as_bool(logical_eq(constrain_par,3))) {

                if (as_bool(logical_eq(constraint_type,1))) {

                    stan::math::assign(sigma_reg_full, append_row(sigma_reg_free,get_base1(restrict_low,1,"restrict_low",1)));
                } else if (as_bool(logical_eq(constraint_type,2))) {

                    stan::math::assign(sigma_reg_full, append_row(sigma_reg_free,get_base1(restrict_high,1,"restrict_high",1)));
                } else if (as_bool(logical_eq(constraint_type,3))) {

                    stan::math::assign(sigma_reg_full, append_row(sigma_reg_free,append_row(get_base1(restrict_high,1,"restrict_high",1),get_base1(restrict_low,1,"restrict_low",1))));
                } else if (as_bool(logical_eq(constraint_type,4))) {

                    stan::math::assign(sigma_reg_full, append_row(sigma_reg_free,get_base1(pinned_pars,1,"pinned_pars",1)));
                }
                stan::math::assign(sigma_abs_full, sigma_abs_free);
                stan::math::assign(L_full, L_free);
            }

            // validate transformed parameters

            // write transformed parameters
            for (int k_1__ = 0; k_1__ < num_legis; ++k_1__) {
                for (int k_0__ = 0; k_0__ < T; ++k_0__) {
                vars__.push_back(L_full[k_0__][k_1__]);
                }
            }
            for (int k_0__ = 0; k_0__ < num_bills; ++k_0__) {
            vars__.push_back(sigma_abs_full[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < num_bills; ++k_0__) {
            vars__.push_back(sigma_reg_full[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < num_bills; ++k_0__) {
            vars__.push_back(B_int_full[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < num_bills; ++k_0__) {
            vars__.push_back(A_int_full[k_0__]);
            }

            if (!include_gqs__) return;
            // declare and define generated quantities



            // validate generated quantities

            // write generated quantities
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_irt_standard";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= (num_bills - num_constrain_sa); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_abs_free" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= (num_legis - num_constrain_l); ++k_1__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "L_free" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= (num_bills - num_constrain_sr); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_reg_free" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= num_fix_low; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "restrict_low" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= num_fix_high; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "restrict_high" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= num_fix_high; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "pinned_pars" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= LX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "legis_x" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SRX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_reg_x" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SAX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_abs_x" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= LX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "legis_x_cons" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SRX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_reg_x_cons" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SAX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_abs_x_cons" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= num_bills; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "B_int_free" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= num_bills; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "A_int_free" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= (m - 1); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "steps_votes" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= (m - 1); ++k_1__) {
            for (int k_0__ = 1; k_0__ <= num_bills; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "steps_votes_grm" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= (num_fix_low + num_fix_high); ++k_1__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "restrict_ord" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "avg_particip";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_1__ = 1; k_1__ <= num_legis; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "L_full" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= num_bills; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_abs_full" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= num_bills; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_reg_full" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= num_bills; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "B_int_full" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= num_bills; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "A_int_full" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= (num_bills - num_constrain_sa); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_abs_free" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= (num_legis - num_constrain_l); ++k_1__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "L_free" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= (num_bills - num_constrain_sr); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_reg_free" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= num_fix_low; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "restrict_low" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= num_fix_high; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "restrict_high" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= num_fix_high; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "pinned_pars" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= LX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "legis_x" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SRX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_reg_x" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SAX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_abs_x" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= LX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "legis_x_cons" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SRX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_reg_x_cons" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SAX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_abs_x_cons" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= num_bills; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "B_int_free" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= num_bills; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "A_int_free" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= (m - 1); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "steps_votes" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= (m - 1); ++k_1__) {
            for (int k_0__ = 1; k_0__ <= num_bills; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "steps_votes_grm" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= (num_fix_low + num_fix_high); ++k_1__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "restrict_ord" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "avg_particip";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_1__ = 1; k_1__ <= num_legis; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "L_full" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= num_bills; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_abs_full" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= num_bills; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_reg_full" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= num_bills; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "B_int_full" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= num_bills; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "A_int_full" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }

}; // model

}




// Code generated by Stan version 2.17.0

#include <stan/model/model_header.hpp>

namespace model_irt_standard_noid_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_irt_standard_noid");
    reader.add_event(246, 246, "end", "model_irt_standard_noid");
    return reader;
}

class model_irt_standard_noid : public prob_grad {
private:
    int N;
    int T;
    vector<int> Y;
    int model_type;
    int hier_type;
    int LX;
    int SRX;
    int SAX;
    int num_legis;
    int num_bills;
    vector<int> ll;
    vector<int> bb;
    vector<int> time;
    vector_d particip;
    vector<matrix_d> legis_pred;
    matrix_d srx_pred;
    matrix_d sax_pred;
    double discrim_reg_sd;
    double discrim_abs_sd;
    double legis_sd;
    double diff_abs_sd;
    double diff_reg_sd;
    double restrict_sd;
    int m;
    vector<int> absence;
    int num_constrain_l;
    int num_constrain_sa;
    int num_constrain_sr;
    vector<int> Y_new;
public:
    model_irt_standard_noid(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_irt_standard_noid(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_irt_standard_noid_namespace::model_irt_standard_noid";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            context__.validate_dims("data initialization", "T", "int", context__.to_vec());
            T = int(0);
            vals_i__ = context__.vals_i("T");
            pos__ = 0;
            T = vals_i__[pos__++];
            validate_non_negative_index("Y", "N", N);
            context__.validate_dims("data initialization", "Y", "int", context__.to_vec(N));
            validate_non_negative_index("Y", "N", N);
            Y = std::vector<int>(N,int(0));
            vals_i__ = context__.vals_i("Y");
            pos__ = 0;
            size_t Y_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < Y_limit_0__; ++i_0__) {
                Y[i_0__] = vals_i__[pos__++];
            }
            context__.validate_dims("data initialization", "model_type", "int", context__.to_vec());
            model_type = int(0);
            vals_i__ = context__.vals_i("model_type");
            pos__ = 0;
            model_type = vals_i__[pos__++];
            context__.validate_dims("data initialization", "hier_type", "int", context__.to_vec());
            hier_type = int(0);
            vals_i__ = context__.vals_i("hier_type");
            pos__ = 0;
            hier_type = vals_i__[pos__++];
            context__.validate_dims("data initialization", "LX", "int", context__.to_vec());
            LX = int(0);
            vals_i__ = context__.vals_i("LX");
            pos__ = 0;
            LX = vals_i__[pos__++];
            context__.validate_dims("data initialization", "SRX", "int", context__.to_vec());
            SRX = int(0);
            vals_i__ = context__.vals_i("SRX");
            pos__ = 0;
            SRX = vals_i__[pos__++];
            context__.validate_dims("data initialization", "SAX", "int", context__.to_vec());
            SAX = int(0);
            vals_i__ = context__.vals_i("SAX");
            pos__ = 0;
            SAX = vals_i__[pos__++];
            context__.validate_dims("data initialization", "num_legis", "int", context__.to_vec());
            num_legis = int(0);
            vals_i__ = context__.vals_i("num_legis");
            pos__ = 0;
            num_legis = vals_i__[pos__++];
            context__.validate_dims("data initialization", "num_bills", "int", context__.to_vec());
            num_bills = int(0);
            vals_i__ = context__.vals_i("num_bills");
            pos__ = 0;
            num_bills = vals_i__[pos__++];
            validate_non_negative_index("ll", "N", N);
            context__.validate_dims("data initialization", "ll", "int", context__.to_vec(N));
            validate_non_negative_index("ll", "N", N);
            ll = std::vector<int>(N,int(0));
            vals_i__ = context__.vals_i("ll");
            pos__ = 0;
            size_t ll_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < ll_limit_0__; ++i_0__) {
                ll[i_0__] = vals_i__[pos__++];
            }
            validate_non_negative_index("bb", "N", N);
            context__.validate_dims("data initialization", "bb", "int", context__.to_vec(N));
            validate_non_negative_index("bb", "N", N);
            bb = std::vector<int>(N,int(0));
            vals_i__ = context__.vals_i("bb");
            pos__ = 0;
            size_t bb_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < bb_limit_0__; ++i_0__) {
                bb[i_0__] = vals_i__[pos__++];
            }
            validate_non_negative_index("time", "N", N);
            context__.validate_dims("data initialization", "time", "int", context__.to_vec(N));
            validate_non_negative_index("time", "N", N);
            time = std::vector<int>(N,int(0));
            vals_i__ = context__.vals_i("time");
            pos__ = 0;
            size_t time_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < time_limit_0__; ++i_0__) {
                time[i_0__] = vals_i__[pos__++];
            }
            validate_non_negative_index("particip", "num_legis", num_legis);
            context__.validate_dims("data initialization", "particip", "vector_d", context__.to_vec(num_legis));
            validate_non_negative_index("particip", "num_legis", num_legis);
            particip = vector_d(static_cast<Eigen::VectorXd::Index>(num_legis));
            vals_r__ = context__.vals_r("particip");
            pos__ = 0;
            size_t particip_i_vec_lim__ = num_legis;
            for (size_t i_vec__ = 0; i_vec__ < particip_i_vec_lim__; ++i_vec__) {
                particip[i_vec__] = vals_r__[pos__++];
            }
            validate_non_negative_index("legis_pred", "T", T);
            validate_non_negative_index("legis_pred", "num_legis", num_legis);
            validate_non_negative_index("legis_pred", "LX", LX);
            context__.validate_dims("data initialization", "legis_pred", "matrix_d", context__.to_vec(T,num_legis,LX));
            validate_non_negative_index("legis_pred", "T", T);
            validate_non_negative_index("legis_pred", "num_legis", num_legis);
            validate_non_negative_index("legis_pred", "LX", LX);
            legis_pred = std::vector<matrix_d>(T,matrix_d(static_cast<Eigen::VectorXd::Index>(num_legis),static_cast<Eigen::VectorXd::Index>(LX)));
            vals_r__ = context__.vals_r("legis_pred");
            pos__ = 0;
            size_t legis_pred_m_mat_lim__ = num_legis;
            size_t legis_pred_n_mat_lim__ = LX;
            for (size_t n_mat__ = 0; n_mat__ < legis_pred_n_mat_lim__; ++n_mat__) {
                for (size_t m_mat__ = 0; m_mat__ < legis_pred_m_mat_lim__; ++m_mat__) {
                    size_t legis_pred_limit_0__ = T;
                    for (size_t i_0__ = 0; i_0__ < legis_pred_limit_0__; ++i_0__) {
                        legis_pred[i_0__](m_mat__,n_mat__) = vals_r__[pos__++];
            }
                }
            }
            validate_non_negative_index("srx_pred", "num_bills", num_bills);
            validate_non_negative_index("srx_pred", "SRX", SRX);
            context__.validate_dims("data initialization", "srx_pred", "matrix_d", context__.to_vec(num_bills,SRX));
            validate_non_negative_index("srx_pred", "num_bills", num_bills);
            validate_non_negative_index("srx_pred", "SRX", SRX);
            srx_pred = matrix_d(static_cast<Eigen::VectorXd::Index>(num_bills),static_cast<Eigen::VectorXd::Index>(SRX));
            vals_r__ = context__.vals_r("srx_pred");
            pos__ = 0;
            size_t srx_pred_m_mat_lim__ = num_bills;
            size_t srx_pred_n_mat_lim__ = SRX;
            for (size_t n_mat__ = 0; n_mat__ < srx_pred_n_mat_lim__; ++n_mat__) {
                for (size_t m_mat__ = 0; m_mat__ < srx_pred_m_mat_lim__; ++m_mat__) {
                    srx_pred(m_mat__,n_mat__) = vals_r__[pos__++];
                }
            }
            validate_non_negative_index("sax_pred", "num_bills", num_bills);
            validate_non_negative_index("sax_pred", "SAX", SAX);
            context__.validate_dims("data initialization", "sax_pred", "matrix_d", context__.to_vec(num_bills,SAX));
            validate_non_negative_index("sax_pred", "num_bills", num_bills);
            validate_non_negative_index("sax_pred", "SAX", SAX);
            sax_pred = matrix_d(static_cast<Eigen::VectorXd::Index>(num_bills),static_cast<Eigen::VectorXd::Index>(SAX));
            vals_r__ = context__.vals_r("sax_pred");
            pos__ = 0;
            size_t sax_pred_m_mat_lim__ = num_bills;
            size_t sax_pred_n_mat_lim__ = SAX;
            for (size_t n_mat__ = 0; n_mat__ < sax_pred_n_mat_lim__; ++n_mat__) {
                for (size_t m_mat__ = 0; m_mat__ < sax_pred_m_mat_lim__; ++m_mat__) {
                    sax_pred(m_mat__,n_mat__) = vals_r__[pos__++];
                }
            }
            context__.validate_dims("data initialization", "discrim_reg_sd", "double", context__.to_vec());
            discrim_reg_sd = double(0);
            vals_r__ = context__.vals_r("discrim_reg_sd");
            pos__ = 0;
            discrim_reg_sd = vals_r__[pos__++];
            context__.validate_dims("data initialization", "discrim_abs_sd", "double", context__.to_vec());
            discrim_abs_sd = double(0);
            vals_r__ = context__.vals_r("discrim_abs_sd");
            pos__ = 0;
            discrim_abs_sd = vals_r__[pos__++];
            context__.validate_dims("data initialization", "legis_sd", "double", context__.to_vec());
            legis_sd = double(0);
            vals_r__ = context__.vals_r("legis_sd");
            pos__ = 0;
            legis_sd = vals_r__[pos__++];
            context__.validate_dims("data initialization", "diff_abs_sd", "double", context__.to_vec());
            diff_abs_sd = double(0);
            vals_r__ = context__.vals_r("diff_abs_sd");
            pos__ = 0;
            diff_abs_sd = vals_r__[pos__++];
            context__.validate_dims("data initialization", "diff_reg_sd", "double", context__.to_vec());
            diff_reg_sd = double(0);
            vals_r__ = context__.vals_r("diff_reg_sd");
            pos__ = 0;
            diff_reg_sd = vals_r__[pos__++];
            context__.validate_dims("data initialization", "restrict_sd", "double", context__.to_vec());
            restrict_sd = double(0);
            vals_r__ = context__.vals_r("restrict_sd");
            pos__ = 0;
            restrict_sd = vals_r__[pos__++];

            // validate, data variables
            check_greater_or_equal(function__,"num_legis",num_legis,1);
            check_greater_or_equal(function__,"num_bills",num_bills,1);
            // initialize data variables
            m = int(0);
            stan::math::fill(m, std::numeric_limits<int>::min());
            validate_non_negative_index("absence", "N", N);
            absence = std::vector<int>(N,int(0));
            stan::math::fill(absence, std::numeric_limits<int>::min());
            num_constrain_l = int(0);
            stan::math::fill(num_constrain_l, std::numeric_limits<int>::min());
            num_constrain_sa = int(0);
            stan::math::fill(num_constrain_sa, std::numeric_limits<int>::min());
            num_constrain_sr = int(0);
            stan::math::fill(num_constrain_sr, std::numeric_limits<int>::min());
            validate_non_negative_index("Y_new", "N", N);
            Y_new = std::vector<int>(N,int(0));
            stan::math::fill(Y_new, std::numeric_limits<int>::min());

            if (as_bool((primitive_value(logical_eq(model_type,4)) || primitive_value(logical_eq(model_type,6))))) {

                stan::math::assign(m, (max(Y) - 1));
            } else if (as_bool((primitive_value(logical_eq(model_type,1)) || primitive_value(logical_eq(model_type,2))))) {

                stan::math::assign(m, 2);
            } else {

                stan::math::assign(m, max(Y));
            }
            for (int n = 1; n <= N; ++n) {

                if (as_bool(logical_gt(get_base1(Y,n,"Y",1),m))) {

                    stan::math::assign(get_base1_lhs(absence,n,"absence",1), 1);
                } else {

                    stan::math::assign(get_base1_lhs(absence,n,"absence",1), 0);
                }
                if (as_bool((primitive_value(logical_eq(model_type,1)) || primitive_value(logical_eq(model_type,2))))) {

                    if (as_bool(logical_gt(min(Y),0))) {

                        stan::math::assign(get_base1_lhs(Y_new,n,"Y_new",1), (get_base1(Y,n,"Y",1) - min(Y)));
                    } else {

                        stan::math::assign(get_base1_lhs(Y_new,n,"Y_new",1), get_base1(Y,n,"Y",1));
                    }
                }
            }

            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            validate_non_negative_index("sigma_abs_free", "num_bills", num_bills);
            num_params_r__ += num_bills;
            validate_non_negative_index("L_free", "num_legis", num_legis);
            validate_non_negative_index("L_free", "T", T);
            num_params_r__ += num_legis * T;
            validate_non_negative_index("sigma_reg_free", "num_bills", num_bills);
            num_params_r__ += num_bills;
            validate_non_negative_index("legis_x", "LX", LX);
            num_params_r__ += LX;
            validate_non_negative_index("sigma_reg_x", "SRX", SRX);
            num_params_r__ += SRX;
            validate_non_negative_index("sigma_abs_x", "SAX", SAX);
            num_params_r__ += SAX;
            validate_non_negative_index("legis_x_cons", "LX", LX);
            num_params_r__ += LX;
            validate_non_negative_index("sigma_reg_x_cons", "SRX", SRX);
            num_params_r__ += SRX;
            validate_non_negative_index("sigma_abs_x_cons", "SAX", SAX);
            num_params_r__ += SAX;
            validate_non_negative_index("steps_votes", "(m - 1)", (m - 1));
            num_params_r__ += (m - 1);
            validate_non_negative_index("steps_votes_grm", "(m - 1)", (m - 1));
            validate_non_negative_index("steps_votes_grm", "num_bills", num_bills);
            num_params_r__ += (m - 1) * num_bills;
            ++num_params_r__;
            validate_non_negative_index("B_int_free", "num_bills", num_bills);
            num_params_r__ += num_bills;
            validate_non_negative_index("A_int_free", "num_bills", num_bills);
            num_params_r__ += num_bills;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_irt_standard_noid() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("sigma_abs_free")))
            throw std::runtime_error("variable sigma_abs_free missing");
        vals_r__ = context__.vals_r("sigma_abs_free");
        pos__ = 0U;
        validate_non_negative_index("sigma_abs_free", "num_bills", num_bills);
        context__.validate_dims("initialization", "sigma_abs_free", "vector_d", context__.to_vec(num_bills));
        vector_d sigma_abs_free(static_cast<Eigen::VectorXd::Index>(num_bills));
        for (int j1__ = 0U; j1__ < num_bills; ++j1__)
            sigma_abs_free(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(sigma_abs_free);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_abs_free: ") + e.what());
        }

        if (!(context__.contains_r("L_free")))
            throw std::runtime_error("variable L_free missing");
        vals_r__ = context__.vals_r("L_free");
        pos__ = 0U;
        validate_non_negative_index("L_free", "T", T);
        validate_non_negative_index("L_free", "num_legis", num_legis);
        context__.validate_dims("initialization", "L_free", "vector_d", context__.to_vec(T,num_legis));
        std::vector<vector_d> L_free(T,vector_d(static_cast<Eigen::VectorXd::Index>(num_legis)));
        for (int j1__ = 0U; j1__ < num_legis; ++j1__)
            for (int i0__ = 0U; i0__ < T; ++i0__)
                L_free[i0__](j1__) = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < T; ++i0__)
            try {
            writer__.vector_unconstrain(L_free[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable L_free: ") + e.what());
        }

        if (!(context__.contains_r("sigma_reg_free")))
            throw std::runtime_error("variable sigma_reg_free missing");
        vals_r__ = context__.vals_r("sigma_reg_free");
        pos__ = 0U;
        validate_non_negative_index("sigma_reg_free", "num_bills", num_bills);
        context__.validate_dims("initialization", "sigma_reg_free", "vector_d", context__.to_vec(num_bills));
        vector_d sigma_reg_free(static_cast<Eigen::VectorXd::Index>(num_bills));
        for (int j1__ = 0U; j1__ < num_bills; ++j1__)
            sigma_reg_free(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(sigma_reg_free);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_reg_free: ") + e.what());
        }

        if (!(context__.contains_r("legis_x")))
            throw std::runtime_error("variable legis_x missing");
        vals_r__ = context__.vals_r("legis_x");
        pos__ = 0U;
        validate_non_negative_index("legis_x", "LX", LX);
        context__.validate_dims("initialization", "legis_x", "vector_d", context__.to_vec(LX));
        vector_d legis_x(static_cast<Eigen::VectorXd::Index>(LX));
        for (int j1__ = 0U; j1__ < LX; ++j1__)
            legis_x(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(legis_x);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable legis_x: ") + e.what());
        }

        if (!(context__.contains_r("sigma_reg_x")))
            throw std::runtime_error("variable sigma_reg_x missing");
        vals_r__ = context__.vals_r("sigma_reg_x");
        pos__ = 0U;
        validate_non_negative_index("sigma_reg_x", "SRX", SRX);
        context__.validate_dims("initialization", "sigma_reg_x", "vector_d", context__.to_vec(SRX));
        vector_d sigma_reg_x(static_cast<Eigen::VectorXd::Index>(SRX));
        for (int j1__ = 0U; j1__ < SRX; ++j1__)
            sigma_reg_x(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(sigma_reg_x);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_reg_x: ") + e.what());
        }

        if (!(context__.contains_r("sigma_abs_x")))
            throw std::runtime_error("variable sigma_abs_x missing");
        vals_r__ = context__.vals_r("sigma_abs_x");
        pos__ = 0U;
        validate_non_negative_index("sigma_abs_x", "SAX", SAX);
        context__.validate_dims("initialization", "sigma_abs_x", "vector_d", context__.to_vec(SAX));
        vector_d sigma_abs_x(static_cast<Eigen::VectorXd::Index>(SAX));
        for (int j1__ = 0U; j1__ < SAX; ++j1__)
            sigma_abs_x(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(sigma_abs_x);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_abs_x: ") + e.what());
        }

        if (!(context__.contains_r("legis_x_cons")))
            throw std::runtime_error("variable legis_x_cons missing");
        vals_r__ = context__.vals_r("legis_x_cons");
        pos__ = 0U;
        validate_non_negative_index("legis_x_cons", "LX", LX);
        context__.validate_dims("initialization", "legis_x_cons", "vector_d", context__.to_vec(LX));
        vector_d legis_x_cons(static_cast<Eigen::VectorXd::Index>(LX));
        for (int j1__ = 0U; j1__ < LX; ++j1__)
            legis_x_cons(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(legis_x_cons);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable legis_x_cons: ") + e.what());
        }

        if (!(context__.contains_r("sigma_reg_x_cons")))
            throw std::runtime_error("variable sigma_reg_x_cons missing");
        vals_r__ = context__.vals_r("sigma_reg_x_cons");
        pos__ = 0U;
        validate_non_negative_index("sigma_reg_x_cons", "SRX", SRX);
        context__.validate_dims("initialization", "sigma_reg_x_cons", "vector_d", context__.to_vec(SRX));
        vector_d sigma_reg_x_cons(static_cast<Eigen::VectorXd::Index>(SRX));
        for (int j1__ = 0U; j1__ < SRX; ++j1__)
            sigma_reg_x_cons(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(sigma_reg_x_cons);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_reg_x_cons: ") + e.what());
        }

        if (!(context__.contains_r("sigma_abs_x_cons")))
            throw std::runtime_error("variable sigma_abs_x_cons missing");
        vals_r__ = context__.vals_r("sigma_abs_x_cons");
        pos__ = 0U;
        validate_non_negative_index("sigma_abs_x_cons", "SAX", SAX);
        context__.validate_dims("initialization", "sigma_abs_x_cons", "vector_d", context__.to_vec(SAX));
        vector_d sigma_abs_x_cons(static_cast<Eigen::VectorXd::Index>(SAX));
        for (int j1__ = 0U; j1__ < SAX; ++j1__)
            sigma_abs_x_cons(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(sigma_abs_x_cons);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_abs_x_cons: ") + e.what());
        }

        if (!(context__.contains_r("steps_votes")))
            throw std::runtime_error("variable steps_votes missing");
        vals_r__ = context__.vals_r("steps_votes");
        pos__ = 0U;
        validate_non_negative_index("steps_votes", "(m - 1)", (m - 1));
        context__.validate_dims("initialization", "steps_votes", "vector_d", context__.to_vec((m - 1)));
        vector_d steps_votes(static_cast<Eigen::VectorXd::Index>((m - 1)));
        for (int j1__ = 0U; j1__ < (m - 1); ++j1__)
            steps_votes(j1__) = vals_r__[pos__++];
        try {
            writer__.ordered_unconstrain(steps_votes);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable steps_votes: ") + e.what());
        }

        if (!(context__.contains_r("steps_votes_grm")))
            throw std::runtime_error("variable steps_votes_grm missing");
        vals_r__ = context__.vals_r("steps_votes_grm");
        pos__ = 0U;
        validate_non_negative_index("steps_votes_grm", "num_bills", num_bills);
        validate_non_negative_index("steps_votes_grm", "(m - 1)", (m - 1));
        context__.validate_dims("initialization", "steps_votes_grm", "vector_d", context__.to_vec(num_bills,(m - 1)));
        std::vector<vector_d> steps_votes_grm(num_bills,vector_d(static_cast<Eigen::VectorXd::Index>((m - 1))));
        for (int j1__ = 0U; j1__ < (m - 1); ++j1__)
            for (int i0__ = 0U; i0__ < num_bills; ++i0__)
                steps_votes_grm[i0__](j1__) = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < num_bills; ++i0__)
            try {
            writer__.ordered_unconstrain(steps_votes_grm[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable steps_votes_grm: ") + e.what());
        }

        if (!(context__.contains_r("avg_particip")))
            throw std::runtime_error("variable avg_particip missing");
        vals_r__ = context__.vals_r("avg_particip");
        pos__ = 0U;
        context__.validate_dims("initialization", "avg_particip", "double", context__.to_vec());
        double avg_particip(0);
        avg_particip = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(avg_particip);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable avg_particip: ") + e.what());
        }

        if (!(context__.contains_r("B_int_free")))
            throw std::runtime_error("variable B_int_free missing");
        vals_r__ = context__.vals_r("B_int_free");
        pos__ = 0U;
        validate_non_negative_index("B_int_free", "num_bills", num_bills);
        context__.validate_dims("initialization", "B_int_free", "vector_d", context__.to_vec(num_bills));
        vector_d B_int_free(static_cast<Eigen::VectorXd::Index>(num_bills));
        for (int j1__ = 0U; j1__ < num_bills; ++j1__)
            B_int_free(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(B_int_free);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable B_int_free: ") + e.what());
        }

        if (!(context__.contains_r("A_int_free")))
            throw std::runtime_error("variable A_int_free missing");
        vals_r__ = context__.vals_r("A_int_free");
        pos__ = 0U;
        validate_non_negative_index("A_int_free", "num_bills", num_bills);
        context__.validate_dims("initialization", "A_int_free", "vector_d", context__.to_vec(num_bills));
        vector_d A_int_free(static_cast<Eigen::VectorXd::Index>(num_bills));
        for (int j1__ = 0U; j1__ < num_bills; ++j1__)
            A_int_free(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(A_int_free);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable A_int_free: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<T__> in__(params_r__,params_i__);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma_abs_free;
            (void) sigma_abs_free;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_abs_free = in__.vector_constrain(num_bills,lp__);
            else
                sigma_abs_free = in__.vector_constrain(num_bills);

            vector<Eigen::Matrix<T__,Eigen::Dynamic,1> > L_free;
            size_t dim_L_free_0__ = T;
            L_free.reserve(dim_L_free_0__);
            for (size_t k_0__ = 0; k_0__ < dim_L_free_0__; ++k_0__) {
                if (jacobian__)
                    L_free.push_back(in__.vector_constrain(num_legis,lp__));
                else
                    L_free.push_back(in__.vector_constrain(num_legis));
            }

            Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma_reg_free;
            (void) sigma_reg_free;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_reg_free = in__.vector_constrain(num_bills,lp__);
            else
                sigma_reg_free = in__.vector_constrain(num_bills);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  legis_x;
            (void) legis_x;  // dummy to suppress unused var warning
            if (jacobian__)
                legis_x = in__.vector_constrain(LX,lp__);
            else
                legis_x = in__.vector_constrain(LX);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma_reg_x;
            (void) sigma_reg_x;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_reg_x = in__.vector_constrain(SRX,lp__);
            else
                sigma_reg_x = in__.vector_constrain(SRX);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma_abs_x;
            (void) sigma_abs_x;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_abs_x = in__.vector_constrain(SAX,lp__);
            else
                sigma_abs_x = in__.vector_constrain(SAX);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  legis_x_cons;
            (void) legis_x_cons;  // dummy to suppress unused var warning
            if (jacobian__)
                legis_x_cons = in__.vector_constrain(LX,lp__);
            else
                legis_x_cons = in__.vector_constrain(LX);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma_reg_x_cons;
            (void) sigma_reg_x_cons;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_reg_x_cons = in__.vector_constrain(SRX,lp__);
            else
                sigma_reg_x_cons = in__.vector_constrain(SRX);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma_abs_x_cons;
            (void) sigma_abs_x_cons;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_abs_x_cons = in__.vector_constrain(SAX,lp__);
            else
                sigma_abs_x_cons = in__.vector_constrain(SAX);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  steps_votes;
            (void) steps_votes;  // dummy to suppress unused var warning
            if (jacobian__)
                steps_votes = in__.ordered_constrain((m - 1),lp__);
            else
                steps_votes = in__.ordered_constrain((m - 1));

            vector<Eigen::Matrix<T__,Eigen::Dynamic,1> > steps_votes_grm;
            size_t dim_steps_votes_grm_0__ = num_bills;
            steps_votes_grm.reserve(dim_steps_votes_grm_0__);
            for (size_t k_0__ = 0; k_0__ < dim_steps_votes_grm_0__; ++k_0__) {
                if (jacobian__)
                    steps_votes_grm.push_back(in__.ordered_constrain((m - 1),lp__));
                else
                    steps_votes_grm.push_back(in__.ordered_constrain((m - 1)));
            }

            T__ avg_particip;
            (void) avg_particip;  // dummy to suppress unused var warning
            if (jacobian__)
                avg_particip = in__.scalar_constrain(lp__);
            else
                avg_particip = in__.scalar_constrain();

            Eigen::Matrix<T__,Eigen::Dynamic,1>  B_int_free;
            (void) B_int_free;  // dummy to suppress unused var warning
            if (jacobian__)
                B_int_free = in__.vector_constrain(num_bills,lp__);
            else
                B_int_free = in__.vector_constrain(num_bills);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  A_int_free;
            (void) A_int_free;  // dummy to suppress unused var warning
            if (jacobian__)
                A_int_free = in__.vector_constrain(num_bills,lp__);
            else
                A_int_free = in__.vector_constrain(num_bills);


            // transformed parameters
            validate_non_negative_index("L_full", "num_legis", num_legis);
            validate_non_negative_index("L_full", "T", T);
            vector<Eigen::Matrix<T__,Eigen::Dynamic,1> > L_full(T, (Eigen::Matrix<T__,Eigen::Dynamic,1> (static_cast<Eigen::VectorXd::Index>(num_legis))));
            stan::math::initialize(L_full, DUMMY_VAR__);
            stan::math::fill(L_full,DUMMY_VAR__);
            validate_non_negative_index("sigma_abs_full", "num_bills", num_bills);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma_abs_full(static_cast<Eigen::VectorXd::Index>(num_bills));
            (void) sigma_abs_full;  // dummy to suppress unused var warning

            stan::math::initialize(sigma_abs_full, DUMMY_VAR__);
            stan::math::fill(sigma_abs_full,DUMMY_VAR__);
            validate_non_negative_index("sigma_reg_full", "num_bills", num_bills);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma_reg_full(static_cast<Eigen::VectorXd::Index>(num_bills));
            (void) sigma_reg_full;  // dummy to suppress unused var warning

            stan::math::initialize(sigma_reg_full, DUMMY_VAR__);
            stan::math::fill(sigma_reg_full,DUMMY_VAR__);
            validate_non_negative_index("B_int_full", "num_bills", num_bills);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  B_int_full(static_cast<Eigen::VectorXd::Index>(num_bills));
            (void) B_int_full;  // dummy to suppress unused var warning

            stan::math::initialize(B_int_full, DUMMY_VAR__);
            stan::math::fill(B_int_full,DUMMY_VAR__);
            validate_non_negative_index("A_int_full", "num_bills", num_bills);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  A_int_full(static_cast<Eigen::VectorXd::Index>(num_bills));
            (void) A_int_full;  // dummy to suppress unused var warning

            stan::math::initialize(A_int_full, DUMMY_VAR__);
            stan::math::fill(A_int_full,DUMMY_VAR__);


            stan::math::assign(L_full, L_free);
            stan::math::assign(sigma_abs_full, sigma_abs_free);
            stan::math::assign(sigma_reg_full, sigma_reg_free);
            stan::math::assign(B_int_full, B_int_free);
            stan::math::assign(A_int_full, A_int_free);

            // validate transformed parameters
            for (int i0__ = 0; i0__ < T; ++i0__) {
                for (int i1__ = 0; i1__ < num_legis; ++i1__) {
                    if (stan::math::is_uninitialized(L_full[i0__](i1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: L_full" << '[' << i0__ << ']' << '[' << i1__ << ']';
                        throw std::runtime_error(msg__.str());
                    }
                }
            }
            for (int i0__ = 0; i0__ < num_bills; ++i0__) {
                if (stan::math::is_uninitialized(sigma_abs_full(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: sigma_abs_full" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < num_bills; ++i0__) {
                if (stan::math::is_uninitialized(sigma_reg_full(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: sigma_reg_full" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < num_bills; ++i0__) {
                if (stan::math::is_uninitialized(B_int_full(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: B_int_full" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < num_bills; ++i0__) {
                if (stan::math::is_uninitialized(A_int_full(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: A_int_full" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning

            // model body
            {
            validate_non_negative_index("pi1", "N", N);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  pi1(static_cast<Eigen::VectorXd::Index>(N));
            (void) pi1;  // dummy to suppress unused var warning

            stan::math::initialize(pi1, DUMMY_VAR__);
            stan::math::fill(pi1,DUMMY_VAR__);
            validate_non_negative_index("pi2", "N", N);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  pi2(static_cast<Eigen::VectorXd::Index>(N));
            (void) pi2;  // dummy to suppress unused var warning

            stan::math::initialize(pi2, DUMMY_VAR__);
            stan::math::fill(pi2,DUMMY_VAR__);


            for (int t = 1; t <= T; ++t) {

                lp_accum__.add(normal_log<propto__>(get_base1(L_free,t,"L_free",1), 0, legis_sd));
            }
            lp_accum__.add(normal_log<propto__>(sigma_abs_free, 0, discrim_abs_sd));
            lp_accum__.add(normal_log<propto__>(sigma_reg_free, 0, discrim_reg_sd));
            lp_accum__.add(normal_log<propto__>(legis_x, 0, 5));
            lp_accum__.add(normal_log<propto__>(sigma_reg_x, 0, 5));
            lp_accum__.add(normal_log<propto__>(sigma_abs_x, 0, 5));
            lp_accum__.add(normal_log<propto__>(legis_x_cons, 0, 5));
            lp_accum__.add(normal_log<propto__>(sigma_reg_x_cons, 0, 5));
            lp_accum__.add(normal_log<propto__>(sigma_abs_x_cons, 0, 5));
            lp_accum__.add(normal_log<propto__>(avg_particip, 0, 5));
            if (as_bool((primitive_value(logical_gt(model_type,2)) && primitive_value(logical_lt(model_type,8))))) {

                for (int i = 1; i <= (m - 2); ++i) {

                    lp_accum__.add(normal_log<propto__>((get_base1(steps_votes,(i + 1),"steps_votes",1) - get_base1(steps_votes,i,"steps_votes",1)), 0, 5));
                }
            } else {

                lp_accum__.add(normal_log<propto__>(steps_votes, 0, 5));
            }
            lp_accum__.add(normal_log<propto__>(B_int_free, 0, diff_reg_sd));
            lp_accum__.add(normal_log<propto__>(A_int_free, 0, diff_abs_sd));
            for (int b = 1; b <= num_bills; ++b) {

                lp_accum__.add(normal_log<propto__>(get_base1(steps_votes_grm,b,"steps_votes_grm",1), 0, 5));
            }
            if (as_bool(logical_eq(model_type,1))) {

                for (int n = 1; n <= N; ++n) {

                    stan::math::assign(get_base1_lhs(pi1,n,"pi1",1), ((get_base1(sigma_reg_full,get_base1(bb,n,"bb",1),"sigma_reg_full",1) * get_base1(get_base1(L_full,get_base1(time,n,"time",1),"L_full",1),get_base1(ll,n,"ll",1),"L_full",2)) - get_base1(B_int_full,get_base1(bb,n,"bb",1),"B_int_full",1)));
                }
                lp_accum__.add(bernoulli_logit_log<propto__>(Y_new, pi1));
            } else if (as_bool(logical_eq(model_type,2))) {

                for (int n = 1; n <= N; ++n) {

                    stan::math::assign(get_base1_lhs(pi1,n,"pi1",1), ((get_base1(sigma_reg_full,get_base1(bb,n,"bb",1),"sigma_reg_full",1) * get_base1(get_base1(L_full,get_base1(time,n,"time",1),"L_full",1),get_base1(ll,n,"ll",1),"L_full",2)) - get_base1(B_int_full,get_base1(bb,n,"bb",1),"B_int_full",1)));
                    stan::math::assign(get_base1_lhs(pi2,n,"pi2",1), ((get_base1(sigma_abs_full,get_base1(bb,n,"bb",1),"sigma_abs_full",1) * get_base1(get_base1(L_full,get_base1(time,n,"time",1),"L_full",1),get_base1(ll,n,"ll",1),"L_full",2)) - get_base1(A_int_full,get_base1(bb,n,"bb",1),"A_int_full",1)));
                    if (as_bool(logical_eq(get_base1(absence,n,"absence",1),1))) {

                        lp_accum__.add(bernoulli_logit_log<propto__>(1, get_base1(pi2,n,"pi2",1)));
                    } else {

                        lp_accum__.add(bernoulli_logit_log<propto__>(0, get_base1(pi2,n,"pi2",1)));
                        lp_accum__.add(bernoulli_logit_log<propto__>(get_base1(Y_new,n,"Y_new",1), get_base1(pi1,n,"pi1",1)));
                    }
                }
            } else if (as_bool(logical_eq(model_type,3))) {

                for (int n = 1; n <= N; ++n) {

                    stan::math::assign(get_base1_lhs(pi1,n,"pi1",1), ((get_base1(sigma_reg_full,get_base1(bb,n,"bb",1),"sigma_reg_full",1) * get_base1(get_base1(L_full,get_base1(time,n,"time",1),"L_full",1),get_base1(ll,n,"ll",1),"L_full",2)) - get_base1(B_int_full,get_base1(bb,n,"bb",1),"B_int_full",1)));
                    lp_accum__.add(ordered_logistic_log<propto__>(get_base1(Y,n,"Y",1), get_base1(pi1,n,"pi1",1), steps_votes));
                }
            } else if (as_bool(logical_eq(model_type,4))) {

                for (int n = 1; n <= N; ++n) {

                    stan::math::assign(get_base1_lhs(pi1,n,"pi1",1), ((get_base1(sigma_reg_full,get_base1(bb,n,"bb",1),"sigma_reg_full",1) * get_base1(get_base1(L_full,get_base1(time,n,"time",1),"L_full",1),get_base1(ll,n,"ll",1),"L_full",2)) - get_base1(B_int_full,get_base1(bb,n,"bb",1),"B_int_full",1)));
                    stan::math::assign(get_base1_lhs(pi2,n,"pi2",1), ((get_base1(sigma_abs_full,get_base1(bb,n,"bb",1),"sigma_abs_full",1) * get_base1(get_base1(L_full,get_base1(time,n,"time",1),"L_full",1),get_base1(ll,n,"ll",1),"L_full",2)) - get_base1(A_int_full,get_base1(bb,n,"bb",1),"A_int_full",1)));
                    if (as_bool(logical_eq(get_base1(absence,n,"absence",1),1))) {

                        lp_accum__.add(bernoulli_logit_log<propto__>(1, get_base1(pi2,n,"pi2",1)));
                    } else {

                        lp_accum__.add(bernoulli_logit_log<propto__>(0, get_base1(pi2,n,"pi2",1)));
                        lp_accum__.add(ordered_logistic_log<propto__>(get_base1(Y,n,"Y",1), get_base1(pi1,n,"pi1",1), steps_votes));
                    }
                }
            } else if (as_bool(logical_eq(model_type,5))) {

                for (int n = 1; n <= N; ++n) {

                    stan::math::assign(get_base1_lhs(pi1,n,"pi1",1), ((get_base1(sigma_reg_full,get_base1(bb,n,"bb",1),"sigma_reg_full",1) * get_base1(get_base1(L_full,get_base1(time,n,"time",1),"L_full",1),get_base1(ll,n,"ll",1),"L_full",2)) - get_base1(B_int_full,get_base1(bb,n,"bb",1),"B_int_full",1)));
                    lp_accum__.add(ordered_logistic_log<propto__>(get_base1(Y,n,"Y",1), get_base1(pi1,n,"pi1",1), get_base1(steps_votes_grm,get_base1(bb,n,"bb",1),"steps_votes_grm",1)));
                }
            } else if (as_bool(logical_eq(model_type,6))) {

                for (int n = 1; n <= N; ++n) {

                    stan::math::assign(get_base1_lhs(pi1,n,"pi1",1), ((get_base1(sigma_reg_full,get_base1(bb,n,"bb",1),"sigma_reg_full",1) * get_base1(get_base1(L_full,get_base1(time,n,"time",1),"L_full",1),get_base1(ll,n,"ll",1),"L_full",2)) - get_base1(B_int_full,get_base1(bb,n,"bb",1),"B_int_full",1)));
                    stan::math::assign(get_base1_lhs(pi2,n,"pi2",1), ((get_base1(sigma_abs_full,get_base1(bb,n,"bb",1),"sigma_abs_full",1) * get_base1(get_base1(L_full,get_base1(time,n,"time",1),"L_full",1),get_base1(ll,n,"ll",1),"L_full",2)) - get_base1(A_int_full,get_base1(bb,n,"bb",1),"A_int_full",1)));
                    if (as_bool(logical_eq(get_base1(absence,n,"absence",1),1))) {

                        lp_accum__.add(bernoulli_logit_log<propto__>(1, get_base1(pi2,n,"pi2",1)));
                    } else {

                        lp_accum__.add(bernoulli_logit_log<propto__>(0, get_base1(pi2,n,"pi2",1)));
                        lp_accum__.add(ordered_logistic_log<propto__>(get_base1(Y,n,"Y",1), get_base1(pi1,n,"pi1",1), get_base1(steps_votes_grm,get_base1(bb,n,"bb",1),"steps_votes_grm",1)));
                    }
                }
            } else if (as_bool(logical_eq(model_type,7))) {

                for (int n = 1; n <= N; ++n) {

                    stan::math::assign(get_base1_lhs(pi1,n,"pi1",1), ((get_base1(sigma_reg_full,get_base1(bb,n,"bb",1),"sigma_reg_full",1) * get_base1(get_base1(L_full,get_base1(time,n,"time",1),"L_full",1),get_base1(ll,n,"ll",1),"L_full",2)) - get_base1(B_int_full,get_base1(bb,n,"bb",1),"B_int_full",1)));
                    stan::math::assign(get_base1_lhs(pi2,n,"pi2",1), ((get_base1(sigma_abs_full,get_base1(bb,n,"bb",1),"sigma_abs_full",1) * get_base1(get_base1(L_full,get_base1(time,n,"time",1),"L_full",1),get_base1(ll,n,"ll",1),"L_full",2)) - get_base1(A_int_full,get_base1(bb,n,"bb",1),"A_int_full",1)));
                    if (as_bool(logical_eq(get_base1(absence,n,"absence",1),1))) {

                        lp_accum__.add(bernoulli_logit_log<propto__>(1, get_base1(pi2,n,"pi2",1)));
                    } else {

                        lp_accum__.add(bernoulli_logit_log<propto__>(0, get_base1(pi2,n,"pi2",1)));
                        lp_accum__.add(poisson_log<propto__>(get_base1(Y,n,"Y",1), get_base1(pi1,n,"pi1",1)));
                    }
                }
            }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("sigma_abs_free");
        names__.push_back("L_free");
        names__.push_back("sigma_reg_free");
        names__.push_back("legis_x");
        names__.push_back("sigma_reg_x");
        names__.push_back("sigma_abs_x");
        names__.push_back("legis_x_cons");
        names__.push_back("sigma_reg_x_cons");
        names__.push_back("sigma_abs_x_cons");
        names__.push_back("steps_votes");
        names__.push_back("steps_votes_grm");
        names__.push_back("avg_particip");
        names__.push_back("B_int_free");
        names__.push_back("A_int_free");
        names__.push_back("L_full");
        names__.push_back("sigma_abs_full");
        names__.push_back("sigma_reg_full");
        names__.push_back("B_int_full");
        names__.push_back("A_int_full");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(num_bills);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(num_legis);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_bills);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(LX);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SRX);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SAX);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(LX);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SRX);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SAX);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((m - 1));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_bills);
        dims__.push_back((m - 1));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_bills);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_bills);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(num_legis);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_bills);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_bills);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_bills);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_bills);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_irt_standard_noid_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d sigma_abs_free = in__.vector_constrain(num_bills);
        vector<vector_d> L_free;
        size_t dim_L_free_0__ = T;
        for (size_t k_0__ = 0; k_0__ < dim_L_free_0__; ++k_0__) {
            L_free.push_back(in__.vector_constrain(num_legis));
        }
        vector_d sigma_reg_free = in__.vector_constrain(num_bills);
        vector_d legis_x = in__.vector_constrain(LX);
        vector_d sigma_reg_x = in__.vector_constrain(SRX);
        vector_d sigma_abs_x = in__.vector_constrain(SAX);
        vector_d legis_x_cons = in__.vector_constrain(LX);
        vector_d sigma_reg_x_cons = in__.vector_constrain(SRX);
        vector_d sigma_abs_x_cons = in__.vector_constrain(SAX);
        vector_d steps_votes = in__.ordered_constrain((m - 1));
        vector<vector_d> steps_votes_grm;
        size_t dim_steps_votes_grm_0__ = num_bills;
        for (size_t k_0__ = 0; k_0__ < dim_steps_votes_grm_0__; ++k_0__) {
            steps_votes_grm.push_back(in__.ordered_constrain((m - 1)));
        }
        double avg_particip = in__.scalar_constrain();
        vector_d B_int_free = in__.vector_constrain(num_bills);
        vector_d A_int_free = in__.vector_constrain(num_bills);
            for (int k_0__ = 0; k_0__ < num_bills; ++k_0__) {
            vars__.push_back(sigma_abs_free[k_0__]);
            }
            for (int k_1__ = 0; k_1__ < num_legis; ++k_1__) {
                for (int k_0__ = 0; k_0__ < T; ++k_0__) {
                vars__.push_back(L_free[k_0__][k_1__]);
                }
            }
            for (int k_0__ = 0; k_0__ < num_bills; ++k_0__) {
            vars__.push_back(sigma_reg_free[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < LX; ++k_0__) {
            vars__.push_back(legis_x[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < SRX; ++k_0__) {
            vars__.push_back(sigma_reg_x[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < SAX; ++k_0__) {
            vars__.push_back(sigma_abs_x[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < LX; ++k_0__) {
            vars__.push_back(legis_x_cons[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < SRX; ++k_0__) {
            vars__.push_back(sigma_reg_x_cons[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < SAX; ++k_0__) {
            vars__.push_back(sigma_abs_x_cons[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < (m - 1); ++k_0__) {
            vars__.push_back(steps_votes[k_0__]);
            }
            for (int k_1__ = 0; k_1__ < (m - 1); ++k_1__) {
                for (int k_0__ = 0; k_0__ < num_bills; ++k_0__) {
                vars__.push_back(steps_votes_grm[k_0__][k_1__]);
                }
            }
        vars__.push_back(avg_particip);
            for (int k_0__ = 0; k_0__ < num_bills; ++k_0__) {
            vars__.push_back(B_int_free[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < num_bills; ++k_0__) {
            vars__.push_back(A_int_free[k_0__]);
            }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            validate_non_negative_index("L_full", "num_legis", num_legis);
            validate_non_negative_index("L_full", "T", T);
            vector<vector_d> L_full(T, (vector_d(static_cast<Eigen::VectorXd::Index>(num_legis))));
            stan::math::initialize(L_full, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(L_full,DUMMY_VAR__);
            validate_non_negative_index("sigma_abs_full", "num_bills", num_bills);
            vector_d sigma_abs_full(static_cast<Eigen::VectorXd::Index>(num_bills));
            (void) sigma_abs_full;  // dummy to suppress unused var warning

            stan::math::initialize(sigma_abs_full, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(sigma_abs_full,DUMMY_VAR__);
            validate_non_negative_index("sigma_reg_full", "num_bills", num_bills);
            vector_d sigma_reg_full(static_cast<Eigen::VectorXd::Index>(num_bills));
            (void) sigma_reg_full;  // dummy to suppress unused var warning

            stan::math::initialize(sigma_reg_full, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(sigma_reg_full,DUMMY_VAR__);
            validate_non_negative_index("B_int_full", "num_bills", num_bills);
            vector_d B_int_full(static_cast<Eigen::VectorXd::Index>(num_bills));
            (void) B_int_full;  // dummy to suppress unused var warning

            stan::math::initialize(B_int_full, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(B_int_full,DUMMY_VAR__);
            validate_non_negative_index("A_int_full", "num_bills", num_bills);
            vector_d A_int_full(static_cast<Eigen::VectorXd::Index>(num_bills));
            (void) A_int_full;  // dummy to suppress unused var warning

            stan::math::initialize(A_int_full, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(A_int_full,DUMMY_VAR__);


            stan::math::assign(L_full, L_free);
            stan::math::assign(sigma_abs_full, sigma_abs_free);
            stan::math::assign(sigma_reg_full, sigma_reg_free);
            stan::math::assign(B_int_full, B_int_free);
            stan::math::assign(A_int_full, A_int_free);

            // validate transformed parameters

            // write transformed parameters
            for (int k_1__ = 0; k_1__ < num_legis; ++k_1__) {
                for (int k_0__ = 0; k_0__ < T; ++k_0__) {
                vars__.push_back(L_full[k_0__][k_1__]);
                }
            }
            for (int k_0__ = 0; k_0__ < num_bills; ++k_0__) {
            vars__.push_back(sigma_abs_full[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < num_bills; ++k_0__) {
            vars__.push_back(sigma_reg_full[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < num_bills; ++k_0__) {
            vars__.push_back(B_int_full[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < num_bills; ++k_0__) {
            vars__.push_back(A_int_full[k_0__]);
            }

            if (!include_gqs__) return;
            // declare and define generated quantities



            // validate generated quantities

            // write generated quantities
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_irt_standard_noid";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= num_bills; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_abs_free" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= num_legis; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "L_free" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= num_bills; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_reg_free" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= LX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "legis_x" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SRX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_reg_x" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SAX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_abs_x" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= LX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "legis_x_cons" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SRX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_reg_x_cons" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SAX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_abs_x_cons" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= (m - 1); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "steps_votes" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= (m - 1); ++k_1__) {
            for (int k_0__ = 1; k_0__ <= num_bills; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "steps_votes_grm" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "avg_particip";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= num_bills; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "B_int_free" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= num_bills; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "A_int_free" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_1__ = 1; k_1__ <= num_legis; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "L_full" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= num_bills; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_abs_full" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= num_bills; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_reg_full" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= num_bills; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "B_int_full" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= num_bills; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "A_int_full" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= num_bills; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_abs_free" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= num_legis; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "L_free" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= num_bills; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_reg_free" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= LX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "legis_x" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SRX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_reg_x" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SAX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_abs_x" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= LX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "legis_x_cons" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SRX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_reg_x_cons" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SAX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_abs_x_cons" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= (m - 1); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "steps_votes" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= (m - 1); ++k_1__) {
            for (int k_0__ = 1; k_0__ <= num_bills; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "steps_votes_grm" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "avg_particip";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= num_bills; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "B_int_free" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= num_bills; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "A_int_free" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_1__ = 1; k_1__ <= num_legis; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "L_full" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= num_bills; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_abs_full" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= num_bills; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_reg_full" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= num_bills; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "B_int_full" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= num_bills; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "A_int_full" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }

}; // model

}




#endif
