% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{arcdist}
\alias{arcdist}
\title{Calculation of distances along arcs}
\usage{
arcdist(p1, p2, output = "distance", origin = c(0, 0, 0),
  radius = authRadius)
}
\arguments{
\item{p1}{Numeric vector, XYZ or longitude-latitude coordinates of the first point along the arc.}

\item{p2}{Numeric vector, XYZ or longitude-latitude coordinates of the last point along the arc.}

\item{output}{Character value, the type of the output value. \code{"distance"} will give the distance
in the metric that was fed to the function for the coordinates or the radius.
\code{"deg"} will output the the distance in degrees, \code{"rad"} will do
so in radians.}

\item{origin}{Numeric vector, the center of the circle in XYZ coordinates (default is 0,0,0).}

\item{radius}{Numeric value, the radius of the circle in case the input points have polar coordinates only.
Unused when XYZ coordinates are entered. Defaults to the authalic radius of Earth ca. 6371.007km.}
}
\value{
A single numeric value.
}
\description{
This function calculates the shortest arc distance between two points.
}
\examples{
# coordinates of two points
point1<- c(0,0)
point2<- c(180,0)
arcdist(point1,point2,"distance")
}

