% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-sp-lines.R
\name{SpLines}
\alias{SpLines}
\alias{SpLines,trigrid-method}
\title{Create a \code{\link[sp]{SpatialLines}} class object from an icosahedral grid}
\usage{
SpLines(gridObj, ...)

\S4method{SpLines}{trigrid}(gridObj, dateLine = "break", res = NULL)
}
\arguments{
\item{gridObj}{(\code{\link{trigrid}} or \code{\link{hexagrid}}) Icosahedral grid object.}

\item{...}{Specific details of the new \code{\link[sp]{SpatialLines}} object.}

\item{dateLine}{(\code{logical})Specifies whether \code{NA}s should be introduced at the dateline to break the boundaries of the faces. 
Can be switched off by setting it to \code{FALSE}.}

\item{res}{(\code{numeric}) The number of points inserted between two vertices, or \code{NULL}, if this is to be set by the package. The default method increases resolution wiht lower tessellation values, and is higher for higher absolute latitudes.}
}
\value{
An object of class \code{\link[sp]{SpatialLines}}.
}
\description{
Create a \code{\link[sp]{SpatialLines}} class object from an icosahedral grid
}
