% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-rgl-grid.R, R/plot-rgl-sp3d.R
\docType{data}
\name{lines3d}
\alias{lines3d}
\alias{lines3d,trigrid-method}
\alias{lines3d,Line-method}
\alias{lines3d,Lines-method}
\alias{lines3d,SpatialLines-method}
\alias{lines3d,SpatialLinesDataFrame-method}
\alias{lines3d,Polygon-method}
\alias{lines3d,Polygons-method}
\alias{lines3d,SpatialPolygons-method}
\alias{lines3d,SpatialPolygonsDataFrame-method}
\title{Methods of 3d line plotting}
\format{
An object of class \code{nonstandardGenericFunction} of length 1.
}
\usage{
lines3d

\S4method{lines3d}{trigrid}(x, arcs = FALSE, ...)

\S4method{lines3d}{Line}(x, radius = authRadius, ...)

\S4method{lines3d}{Lines}(x, radius = authRadius, ...)

\S4method{lines3d}{SpatialLines}(x, radius = authRadius, ...)

\S4method{lines3d}{SpatialLinesDataFrame}(x, radius = authRadius, ...)

\S4method{lines3d}{Polygon}(x, radius = authRadius, ...)

\S4method{lines3d}{Polygons}(x, radius = authRadius, ...)

\S4method{lines3d}{SpatialPolygons}(x, radius = authRadius, ...)

\S4method{lines3d}{SpatialPolygonsDataFrame}(x, radius = authRadius, ...)
}
\arguments{
\item{x}{(\code{\link{trigrid}}, \code{\link{hexagrid}}, \code{\link{facelayer}} or \code{sp}) Object to be plotted.}

\item{arcs}{\code{logical} Value setting whether great circle arcs or segments shall be drawn betwenn the points of the grid.}

\item{...}{Further graphical parameters passed to (see \code{\link[rgl]{plot3d}}).}

\item{radius}{(\code{numeric}) Used for plotting objects that inherit from \code{Spatial*}. The radius of the sphere the sp objects are plotted with. Default to the authalic (R2) radius of Earth.}
}
\value{
The function does not return any value.
}
\description{
This is a generic function used to plot the edge lines of either a \code{trigrid} or a \code{hexagrid} object, a \code{facelayer}, or \code{Spatial} objects in 3d space. The method is also implemented for 
the object classes defined by the package 'sp'.
}
\details{
The function is built on the openGL renderer of the R package \code{rgl}, which needs to be installed for the function to run. Although the function is works without attaching rgl, note that if you want to attach both \code{icosa} and \code{rgl},the \code{rgl} package has to be loaded ifrst otherwise the function will not be usable.
}
\examples{
# create a hexagonal grid
  g <- hexagrid(c(2,2))
# plot the grid in 3d space
#  lines3d(g, col="blue")
}
\keyword{datasets}
