% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-spherical.R
\name{rpsphere}
\alias{rpsphere}
\title{Random point generation on the surface of a sphere}
\usage{
rpsphere(n = 1, output = "cartesian", radius = authRadius, origin = c(0, 0, 0))
}
\arguments{
\item{n}{(\code{numeric}) The number of random points to be created.}

\item{output}{(\code{character}) The coordinate system of the new points. Can either be 
\code{"cartesian"} for XYZ coordiates or \code{"polar"} for spherical, 
longitude-latitudes coordinates.}

\item{radius}{(\code{numeric}) The radius of the sphere}

\item{origin}{(\code{numeric}) The center of the sphere (XYZ coordinates).}
}
\value{
A 3-column (XYZ) or a 2-column (long-lat) \code{numeric} matrix.
}
\description{
This function will create a predefined number of points randomly distributed
on the surface of a sphere with a given radius.
}
\details{
The function uses a three dimension normal distribution to generate points, 
which are then projected to the surface of the sphere.
}
\examples{
 randomPoints <- rpsphere(2000, output="polar")
# observe latitudinal pattern
 plot(randomPoints, xlim=c(-180, 180), ylim=c(-90, 90))

}
