% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iplot.R
\name{iplot}
\alias{iplot}
\title{Interactive Ichimoku Cloud Plot}
\usage{
iplot(
  x,
  ticker,
  theme = c("original", "dark", "solarized", "mono"),
  message,
  strat = TRUE,
  ...,
  launch.browser = TRUE
)
}
\arguments{
\item{x}{an object of class 'ichimoku'.}

\item{ticker}{(optional) specify a ticker (or other text) to include in the
chart heading. If not set, the ticker saved within the ichimoku object
will be used.}

\item{theme}{[default 'original'] with alternative choices of 'dark',
'solarized' or 'mono'.}

\item{message}{(optional) specify a chart message to display under the title.}

\item{strat}{[default TRUE] if the ichimoku object contains a strategy, the
periods for which the strategy results in a position will be shaded, and
the strategy printed as the chart message (if a message is not already
specified). Set to FALSE to turn off this behaviour.}

\item{...}{additional parameters passed along to the 'options' argument of
\code{shiny::shinyApp()}.}

\item{launch.browser}{[default TRUE] If TRUE, the system's default web
browser will be launched automatically after the app is started. The value
of this argument can also be a function to call with the application's URL.
To use the default Shiny viewer in RStudio, please specify
\code{getOption("shiny.launch.browser")}.}
}
\value{
Returns a Shiny app object with class 'shiny.appobj'.
}
\description{
Plot Ichimoku Kinko Hyo cloud charts from ichimoku objects in R Shiny,
    allowing full customisation of chart elements in an interactive
    environment. Intuitive cursor infotip provides ready access to the data
    directly from the chart.
}
\details{
This function has a dependency on the 'shiny' package.
}
\examples{
if (interactive()) {
# Only run examples in interactive R sessions
cloud <- ichimoku(sample_ohlc_data, ticker = "TKR")
iplot(cloud)

# To open in RStudio viewer instead of default browser
iplot(cloud, launch.browser = getOption("shiny.launch.browser"))
}

}
