% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{tradingDays}
\alias{tradingDays}
\title{Select Trading Days}
\usage{
tradingDays(x, holidays, ...)
}
\arguments{
\item{x}{a vector of POSIXct date objects.}

\item{holidays}{(optional) a vector, or function which outputs a
vector, of dates defined as holidays. If not specified, New Year's and
Christmas day are defined as holidays by default.}

\item{...}{other arguments to be passed along.}
}
\value{
A vector of logical values: TRUE if the corresponding element of 'x'
    is a weekday and not a holiday, FALSE otherwise.
}
\description{
Used by \code{\link{ichimoku}} to subset a vector of dates to trading days.
}
\examples{
dates <- seq(from = as.POSIXct("2020-01-01"), by = "1 day", length.out = 7)
tradingDays(dates)

}
