% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.github.R
\name{download.github}
\alias{download.github}
\title{Download GitHub Repository}
\usage{
download.github(repo, dir = ".", quiet = FALSE)
}
\arguments{
\item{repo}{GitHub reference of the form \verb{owner/repo[/subdir]@ref}.}

\item{dir}{directory to download to.}

\item{quiet}{whether to suppress messages.}
}
\value{
Name of downloaded \verb{tar.gz} file.
}
\description{
Download a repository from GitHub in \file{tar.gz} format.
}
\note{
In general, TAF scripts do not access the internet using
\code{download.github} or similar functions. Instead, data and software are
declared in \verb{DATA.bib} and \verb{SOFTWARE.bib} and then downloaded using
\code{\link{taf.bootstrap}}. The exception is when a bootstrap data script is
used to fetch data files from a web service (see
\href{https://github.com/ices-taf/doc/wiki/Bib-entries}{TAF Wiki}).
}
\examples{
\dontrun{
# Specify release tag
download.github("ices-tools-prod/icesTAF@2.0-0")

# Specify SHA reference code
download.github("ices-tools-prod/icesTAF@d5a8947")
}

}
\seealso{
\code{\link{taf.bootstrap}} uses \code{download.github} to fetch software and
data repositories.

\code{\link{download}} downloads a file.

\code{\link{untar}} extracts a \verb{tar.gz} archive.

\code{\link{taf.install}} installs a package in \verb{tar.gz} format.

\code{\link{icesTAF-package}} gives an overview of the package.
}
