% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ranges.R
\name{icd9ExpandRange}
\alias{\%i9d\%}
\alias{\%i9da\%}
\alias{\%i9mj\%}
\alias{\%i9s\%}
\alias{\%i9sa\%}
\alias{icd9ExpandRange}
\alias{icd9ExpandRangeDecimal}
\alias{icd9ExpandRangeMajor}
\alias{icd9ExpandRangeShort}
\title{take two ICD-9 codes and expand range to include all child codes}
\usage{
icd9ExpandRange(start, end, isShort, onlyReal = TRUE)

icd9ExpandRangeShort(start, end, onlyReal = TRUE)

icd9ExpandRangeMajor(start, end, onlyReal = TRUE)

icd9ExpandRangeDecimal(start, end, onlyReal = TRUE)

start \%i9da\% end

start \%i9sa\% end

start \%i9d\% end

start \%i9mj\% end

start \%i9s\% end
}
\arguments{
\item{start,end}{is a character vector of ICD-9 codes. If fewer than
five characters is given in a code, then the digits are greedily assigned
to hundreds, then tens, then units, before the decimal parts. E.g. "10"
becomes "010", not "0010"}

\item{isShort}{single logical value which determines whether the ICD-9 code
provided is in short (TRUE) or decimal (FALSE) form. Where reasonable, this
is guessed from the input data.}

\item{onlyReal}{single logical value, if TRUE, will limit the search to those
codes which appear in the master list, not just syntactically valid codes.
Since nearly valid, out-dated or new codes may be missed, not limiting to
'real' values will be useful. Ultimately, there will need to be annual (and
all-time) master lists of codes and the ability to test against a given
master list given the year of the ICD-9 coding.}
}
\description{
this is cumbersome code, covering a whole load of edge cases
  relating to the fact that icd9 codes are \strong{not} in numeric order. An
  alternative strategy would be to list all the ICD9 codes, then a range
  would just pick out start and finish positions, and return subset of the
  list. Not all ICD-9 codes are valid, including some parent codes which have
  valid children. However, I expect at least some of these have been used in
  some billing databases.

  As with \code{link{icd9ExpandRangeShort}} great care is taken not to
  include codes which have children not in the range. E.g. "100.9" to "101.1"
  would _not_ include code "101".

  \code{onlyReal} default is \code{TRUE} (a change from previous versions)
  since this is far more likely to be useful to the end user.
}
\examples{
"4280 " \%i9s\% "4289 "
"V80 " \%i9s\% " V8210 "

# the following should give all codes in 428 EXCEPT "428",
# and all codes upto 43014 EXCEPT 430 and 4301
icd9ExpandRangeShort("4280 ", "43014")
}
\seealso{
Other ICD-9 ranges: \code{\link{icd9Children}},
  \code{\link{icd9Children}},
  \code{\link{icd9ChildrenDecimal}},
  \code{\link{icd9ChildrenShort}};
  \code{\link{icd9Condense}},
  \code{\link{icd9CondenseDecimal}},
  \code{\link{icd9CondenseShort}},
  \code{\link{icd9CondenseToMajor}},
  \code{\link{icd9CondenseToMajorDecimal}},
  \code{\link{icd9CondenseToMajorShort}};
  \code{\link{icd9ExpandMinor}}
}

