% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9DropLeadingZeroes}
\alias{icd9DropLeadingZeroes}
\alias{icd9DropLeadingZeroesDecimal}
\alias{icd9DropLeadingZeroesMajor}
\alias{icd9DropLeadingZeroesShort}
\title{drop zero padding from decimal ICD-9 code.}
\usage{
icd9DropLeadingZeroes(icd9, isShort, dropZeroV = FALSE,
  invalidAction = icd9InvalidActions)

icd9DropLeadingZeroesDecimal(icd9Decimal, dropZeroV = FALSE,
  invalidAction = icd9InvalidActions)

icd9DropLeadingZeroesShort(icd9Short, dropZeroV = FALSE,
  invalidAction = icd9InvalidActions)

icd9DropLeadingZeroesMajor(major, dropZeroV = FALSE,
  invalidAction = icd9InvalidActions)
}
\arguments{
\item{icd9}{is a character vector of ICD-9 codes. If fewer than five characters is
given in a code, then the digits are greedily assigned to hundreds, then
tens, then units, before the decimal parts. E.g. "10" becomes "010", not
"0010"}

\item{dropZeroV}{single logical, if TRUE will additionally drop V0x.yz to
Vx.yz In the case of 'short' form codes, this is only valid when there is
no decimal part, e.g. V01 can become V1, but V0123 cannot become V123
because its meaning changes.}

\item{invalidAction}{character string (unit length) containing one of:
  "ignore", "silent", "warn", "stop"

  - \code{ignore} no check for validity of ICD-9 code is made implicitly.
  This is the fastest option. If the function call is explicitly to check
  validity, e.g. icd9ValidShort(icd9Short = "12345", invalidAction =
  "ignore"), then the behavior is the same as \code{silent}.

  - \code{silent} invalid ICD-9 codes are replaced silently by \code{NA}
  (actually \code{NA_character_}). If the function returns \code{TRUE} or
  \code{FALSE} rather than the ICD-9 code itself, then \code{FALSE} is
  returned

  - \code{warn} invalid ICD-9 codes are replaced by \code{NA} with a warning
  revealing the invalid code(s).

  - \code{stop} stop with error if any invalid codes are found in input. This
  is the preferred method when doing one-time validation, e.g. of the
  co-morbidity mapping lists.}

\item{icd9Decimal}{character vector of ICD-9 codes. If fewer than five characters is given in a
code, then the digits are greedily assigned to hundreds, then tens, then
units, before the decimal parts. E.g. "10" becomes "010", not "0010"}

\item{icd9Short}{is a character vector of ICD-9 codes. If fewer than five characters is given
in a code, then the digits are greedily assigned to hundreds, then tens,
then units, before the decimal parts. E.g. "10" becomes "010", not "0010"}
}
\value{
character vector of ICD-9 codes with extra zeroes dropped from major
  part
}
\description{
decimal form ICD-9 codes are not ambiguous if the leading zeroes
  are dropped. Some short-form ICD-9 codes would not be ambiguous, e.g. "1"
  but many would be problematic, so no function is provided to do this for
  short-form codes. This is the inverse of icd9AddLeadingZeroesDecimal
}
\seealso{
Other ICD-9 convert: \code{\link{icd9DecimalToShort}};
  \code{\link{icd9MajMinToDecimal}},
  \code{\link{icd9MajMinToParts}},
  \code{\link{icd9MajMinToShort}},
  \code{\link{icd9PartsRecompose}},
  \code{\link{icd9PartsToDecimal}},
  \code{\link{icd9PartsToDecimal}},
  \code{\link{icd9PartsToShort}},
  \code{\link{icd9PartsToShort}};
  \code{\link{icd9ShortToDecimal}}
}
\keyword{internal}
\keyword{manip}

