% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R, R/z-deprecated.R
\name{set_icd_class}
\alias{set_icd_class}
\alias{icd9}
\alias{as.icd9}
\alias{icd9cm}
\alias{as.icd9cm}
\alias{as.icd10}
\alias{icd10}
\alias{as.icd10cm}
\alias{icd10cm}
\alias{comorbidity_map}
\alias{as.comorbidity_map}
\alias{as.icd_comorbidity_map}
\title{Construct ICD-9 and ICD-10 data types}
\usage{
icd9(x)

as.icd9(x)

icd9cm(x)

as.icd9cm(x)

as.icd10(x)

icd10(x)

as.icd10cm(x, short_code = NULL)

icd10cm(x)

comorbidity_map(x)

as.comorbidity_map(x)

as.icd_comorbidity_map(...)
}
\arguments{
\item{x}{object to set class \code{icd9}}

\item{...}{arguments passed on to other functions}

\item{warn}{single logical value, if \code{TRUE} will gives warning when
converting between types. ICD-9 to ICD-10 will cause an error regardless.}
}
\description{
Takes an R structure and sets class to an ICD type. In the case of ICD-9 and
ICD-10 codes, if a particular sub-type is set, e.g. ICD-9-CM (\code{icd9cm}),
then an ICD-9 class (\code{icd9}) is also set.
}
\details{
The \code{as.} function e.g. \code{as.icd9}, do checking and try to put
multiple classes in a nice order. Calling the bare constructor, e.g.
\code{icd9} just prepends the new class and returns without any checks. The
latter is much faster, but for most uses, \code{as.icd9} and siblings would
be better.

Some features make more sense as attributes. E.g. setting code type to
\code{short} or \code{decimal}.

Using \code{attributes} instead of \code{class} is a better fit for
  the data. It simplifies S3 dispatch, and appears to be very fast to get or
  set using the built-in R functions.
}
\section{Deprecated function names}{
 Future versions of \pkg{icd} will drop
  the \code{icd_} prefix. For example, \code{charlson} should be used in
  favor of \code{icd_charlson}. To distinguish \pkg{icd} function calls,
  consider using the prefix \code{icd::} instead, e.g., \code{icd::charlson}.
  Functions which specifically operate on either ICD-9 or ICD-10 codes or
  their sub-types will retain the prefix. E.g.
  \code{\link{icd9_comorbid_ahrq}}. \pkg{icd} specific classes also retain
  the prefix, e.g., \code{\link{icd_wide_data}}.
}

\examples{
x = as.icd10("A1009")
attr(x, "icd_short_diag") <- TRUE
x
attributes(x) <- list(icd_short_diag = NULL)
x

y <- as.decimal_diag(as.icd10("A10.09"))
y
is.short_diag(y)

j <- as.short_diag(as.icd10(c("A11", "B2222")))
j[2] <- "C33"
stopifnot(is.short_diag(j))
stopifnot(is.icd10(j), is.icd10(j[1]), is.icd10(j[[1]]))
j[[1]] <- "D44001"
stopifnot(is.short_diag(j))
stopifnot(is.icd10(j), is.icd10(j[2]), is.icd10(j[[2]]))
}
\seealso{
\code{\link{icd_long_data}}
}
\keyword{internal}
