% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_pccc.R
\name{generate_maps_pccc}
\alias{generate_maps_pccc}
\alias{icd9_generate_map_pccc_dx}
\alias{icd9_generate_map_pccc_pcs}
\alias{icd10_generate_map_pccc_dx}
\alias{icd10_generate_map_pccc_pcs}
\title{Generate PCCC data}
\usage{
generate_maps_pccc(save_data = TRUE)

icd9_generate_map_pccc_dx(save_data = TRUE)

icd9_generate_map_pccc_pcs(save_data = TRUE)

icd10_generate_map_pccc_dx(save_data)

icd10_generate_map_pccc_pcs(save_data = TRUE)
}
\arguments{
\item{save_data}{single logical value, if \code{TRUE} will save the generated
data}
}
\description{
There are seven maps: ICD-9 diagnosis and procedure codes, ICD-10 diagnosis
and procedure codes. There is no eighth map because there are no elements of
ICD-10 procedure codes for 'fixed' comorbidities.
}
\details{
The 'fixed' data are those identified in the JAMA Pediatrics letter which
required exact matching to avoid overly broad capture of diagnoses.
}
\examples{
icd:::generate_maps_pccc(save_data = FALSE)
}
\keyword{internal}
