% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/real.R, R/z-deprecated.R
\name{get_billable}
\alias{get_billable}
\alias{get_billable.default}
\alias{get_billable.icd9cm}
\alias{get_billable.icd9}
\alias{get_billable.icd10cm}
\alias{get_billable.icd10}
\alias{icd_get_billable}
\alias{icd_get_billable.icd9}
\alias{icd_get_billable.icd9cm}
\alias{icd_get_billable.icd10}
\alias{icd_get_billable.icd10cm}
\title{Get billable ICD codes}
\usage{
get_billable(...)

\method{get_billable}{default}(x, short_code = guess_short(x), ...)

\method{get_billable}{icd9cm}(x, short_code = guess_short(x),
  invert = FALSE, icd9cm_edition = icd9cm_latest_edition(), ...)

\method{get_billable}{icd9}(...)

\method{get_billable}{icd10cm}(x, short_code = guess_short(x),
  invert = FALSE, icd10cm_edition = "2016", ...)

\method{get_billable}{icd10}(x, short_code = guess_short(x), invert = FALSE,
  icd10cm_edition = "2016", ...)

icd_get_billable(...)

icd_get_billable.icd9(...)

icd_get_billable.icd9cm(...)

icd_get_billable.icd10(...)

icd_get_billable.icd10cm(...)
}
\arguments{
\item{...}{arguments passed on to other functions}

\item{x}{input vector of ICD codes}

\item{short_code}{single logical value which determines whether the ICD-9
code provided is in short (\code{TRUE}) or decimal (\code{FALSE}) form.
Where reasonable, this is guessed from the input data.}

\item{invert}{Single logical value. Returns the inverse of the result. E.g.
if seeking valid ICD-9 codes, the invalid ones are returned.}

\item{icd9cm_edition}{e.g. "32", not ICD-9 vs ICD-10}

\item{...}{arguments passed on to other functions}

\item{...}{arguments passed on to other functions}

\item{...}{arguments passed on to other functions}

\item{...}{arguments passed on to other functions}
}
\description{
Get billable ICD codes, implicitly, this refers to an ICD
  implementation which is specialized for a country, typically for billing,
  e.g. ICD-9-CM in the USA.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Get billable ICD codes, guessing whether ICD-9
or ICD-10, and code short vs decimal type.

\item \code{icd9cm}: Get billable ICD-9-CM codes

\item \code{icd9}: Get billable ICD-9 codes, which is currently
implemented assuming ICD-9-CM

\item \code{icd10cm}: Get billable, i.e. leaf nodes from ICD-10-CM

\item \code{icd10}: Get billable, i.e. leaf nodes from ICD-10-CM
}}

\section{Deprecated function names}{
 Future versions of \pkg{icd} will drop
  the \code{icd_} prefix. For example, \code{charlson} should be used in
  favor of \code{icd_charlson}. To distinguish \pkg{icd} function calls,
  consider using the namespace prefix \code{icd::} instead, e.g.,
  \code{icd::charlson}. Functions which specifically operate on either ICD-9
  or ICD-10 codes or their subtypes will retain the prefix. E.g.
  \code{\link{icd9_comorbid_ahrq}}. \pkg{icd} specific classes also retain
  the prefix, e.g., \code{\link{icd_wide_data}}.
}

\keyword{internal}
