% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain-table.R, R/z-deprecated.R
\name{explain_table}
\alias{explain_table}
\alias{explain_table.default}
\alias{explain_table.icd9}
\alias{explain_table.icd10}
\alias{explain_table.icd9cm}
\alias{explain_table.icd10cm}
\alias{icd_explain_table.icd10}
\alias{icd_explain_table.icd10cm}
\alias{icd_explain_table.icd9}
\alias{icd_explain_table.icd9cm}
\alias{icd_explain_table}
\title{Explain ICD-9 and ICD-10 codes in English from decimal  (123.45 style),
Tabulates the decimal format alongside converted non-decimal format.}
\usage{
explain_table(...)

\method{explain_table}{default}(x, short_code = guess_short(x),
  condense = FALSE, brief = TRUE, warn = TRUE, ...)

\method{explain_table}{icd9}(...)

\method{explain_table}{icd10}(...)

\method{explain_table}{icd9cm}(x, short_code = guess_short(x),
  condense = FALSE, brief = TRUE, warn = TRUE, ...)

\method{explain_table}{icd10cm}(x, short_code = guess_short(x),
  condense = FALSE, brief = TRUE, warn = TRUE, ...)

icd_explain_table.icd10(...)

icd_explain_table.icd10cm(...)

icd_explain_table.icd9(...)

icd_explain_table.icd9cm(...)

icd_explain_table(...)
}
\arguments{
\item{...}{arguments passed on to other functions}

\item{x}{vector or other structure of ICD codes to explain in human language}

\item{short_code}{single logical value which determines whether the ICD-9
code provided is in short (\code{TRUE}) or decimal (\code{FALSE}) form.
Where reasonable, this is guessed from the input data.}

\item{condense}{single logical value which indicates whether to condense the
given set of ICD-9 codes by replacing subsets of codes with 'parent' codes
which exactly encompass certain subsets. E.g. If all cholera diagnoses are
provided, only '001 - Cholera' needs to be displayed, not all sub-types.}

\item{brief}{single logical value, default is \code{FALSE}. If \code{TRUE},
the short description from the canonical CMS descriptions (included in
\code{data-raw}) will be used, otherwise the long description is used.}

\item{warn}{single logical value, default is \code{TRUE}, meaning that codes
which do not correspond to diagnoses, or to three-digit codes, will trigger
a warning.}

\item{...}{arguments passed on to other functions}
}
\value{
data frame with fields for ICD-9 code, name and description. The
  ordering is in the same order as input, including rows filled with NA for
  invalid input codes
}
\description{
Output is ordered in the same order as the input. A logical column
\code{ismajor} indicates if the code is a parent Category.
}
\details{
If the code is both a valid ICD9 and a ICD10 the output will default the
descriptions to ICD10.  The code would otherwise have to be explicitly cast
to get ICD9 descriptions.

A column for source year may be added in the future. Other changes may occur
this new feature gets testing and use.

If the input x is of mixed type it will choose to convert by
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: explaining ICD codes from a character vector, guessing ICD version

\item \code{icd9}: from vector of ICD-9 codes.

\item \code{icd10}: from vector of ICD-10 codes.

\item \code{icd9cm}: explain character vector of ICD1-10-CM codes

\item \code{icd10cm}: explain character vector of ICD1-10-CM codes
}}

\section{Deprecated function names}{
 Future versions of \pkg{icd} will drop
  the \code{icd_} prefix. For example, \code{charlson} should be used in
  favor of \code{icd_charlson}. To distinguish \pkg{icd} function calls,
  consider using the namespace prefix \code{icd::} instead, e.g.,
  \code{icd::charlson}. Functions which specifically operate on either ICD-9
  or ICD-10 codes or their subtypes will retain the prefix. E.g.
  \code{\link{icd9_comorbid_ahrq}}. \pkg{icd} specific classes also retain
  the prefix, e.g., \code{\link{icd_wide_data}}.

 Future versions of \pkg{icd} will drop
  the \code{icd_} prefix. For example, \code{charlson} should be used in
  favor of \code{icd_charlson}. To distinguish \pkg{icd} function calls,
  consider using the namespace prefix \code{icd::} instead, e.g.,
  \code{icd::charlson}. Functions which specifically operate on either ICD-9
  or ICD-10 codes or their subtypes will retain the prefix. E.g.
  \code{\link{icd9_comorbid_ahrq}}. \pkg{icd} specific classes also retain
  the prefix, e.g., \code{\link{icd_wide_data}}.

 Future versions of \pkg{icd} will drop
  the \code{icd_} prefix. For example, \code{charlson} should be used in
  favor of \code{icd_charlson}. To distinguish \pkg{icd} function calls,
  consider using the namespace prefix \code{icd::} instead, e.g.,
  \code{icd::charlson}. Functions which specifically operate on either ICD-9
  or ICD-10 codes or their subtypes will retain the prefix. E.g.
  \code{\link{icd9_comorbid_ahrq}}. \pkg{icd} specific classes also retain
  the prefix, e.g., \code{\link{icd_wide_data}}.

 Future versions of \pkg{icd} will drop
  the \code{icd_} prefix. For example, \code{charlson} should be used in
  favor of \code{icd_charlson}. To distinguish \pkg{icd} function calls,
  consider using the namespace prefix \code{icd::} instead, e.g.,
  \code{icd::charlson}. Functions which specifically operate on either ICD-9
  or ICD-10 codes or their subtypes will retain the prefix. E.g.
  \code{\link{icd9_comorbid_ahrq}}. \pkg{icd} specific classes also retain
  the prefix, e.g., \code{\link{icd_wide_data}}.

 Future versions of \pkg{icd} will drop
  the \code{icd_} prefix. For example, \code{charlson} should be used in
  favor of \code{icd_charlson}. To distinguish \pkg{icd} function calls,
  consider using the namespace prefix \code{icd::} instead, e.g.,
  \code{icd::charlson}. Functions which specifically operate on either ICD-9
  or ICD-10 codes or their subtypes will retain the prefix. E.g.
  \code{\link{icd9_comorbid_ahrq}}. \pkg{icd} specific classes also retain
  the prefix, e.g., \code{\link{icd_wide_data}}.
}

\author{
Ed Lee

Ed Lee
}
\keyword{internal}
