% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_similar_colour.R
\name{find_similar_colour}
\alias{find_similar_colour}
\title{Find a Named Colour that is Similar to Any Given Colour}
\usage{
find_similar_colour(
  colour,
  distance = c("euclidean", "manhattan"),
  verbose = interactive()
)
}
\arguments{
\item{colour}{a colour specified in one of three forms: a hexadecimal string
of the form \code{"#rrggbb"} or \code{"#rrggbbaa"}, a numeric vector of length 3 or a
numeric matrix with dimensions \code{c(3, 1)}, as it is returned by
\code{\link[=col2rgb]{col2rgb()}}.
Numeric values must be between 0 and 255.}

\item{distance}{character indicating the distance metric to be used.}

\item{verbose}{should additional output be produced? This shows the RGB values
for the input colour, the most similar named colour and the difference between
the two.}
}
\value{
a character of length one with the name of the most similar named colour.
}
\description{
Find the named colour that is most similar to a given colour.
}
\examples{
find_similar_colour("#d339da")
find_similar_colour(c(124, 34, 201))

# suppress additional output
find_similar_colour("#85d3a1", verbose = FALSE)

# use Manhattan distance
find_similar_colour(c(124, 34, 201), distance = "manhattan")

}
