% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iaibase.R
\name{fit_transform}
\alias{fit_transform}
\title{Fit an imputation model using the given features and impute the missing
values in these features}
\usage{
fit_transform(lnr, X, ...)
}
\arguments{
\item{lnr}{The learner or grid to use for imputation}

\item{X}{The features of the data.}

\item{...}{Refer to the Julia documentation for available parameters.}
}
\description{
Similar to calling
\code{\link{fit.imputation_learner}}
followed by
\code{\link{transform}}
}
\details{
Julia Equivalent:
\href{https://docs.interpretable.ai/v3.1.1/IAIBase/reference/#IAI.fit_transform!}{\code{IAI.fit_transform!}}
}
\examples{
\dontrun{
X <- iris
X[1, 1] <- NA
grid <- iai::grid_search(
    iai::imputation_learner(),
    method = c("opt_knn", "opt_tree"),
)
iai::fit_transform(grid, X)
}
}
