% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iaibase.R
\name{fit.grid_search}
\alias{fit.grid_search}
\title{Fits a \code{\link{grid_search}} to the training data}
\usage{
\method{fit}{grid_search}(obj, X, ...)
}
\arguments{
\item{obj}{The grid search to fit.}

\item{X}{The features of the data.}

\item{...}{Other parameters, including zero or more target vectors as
required by the problem type. Refer to the Julia documentation for
available parameters.}
}
\description{
Julia Equivalent:
\href{https://docs.interpretable.ai/v3.2.1/IAIBase/reference/#IAI.fit\%21-Tuple\%7BGridSearch\%7D}{\code{IAI.fit!}}
}
\examples{
\dontrun{
X <- iris[, 1:4]
y <- iris$Species
grid <- iai::grid_search(
    iai::optimal_tree_classifier(max_depth = 1),
)
iai::fit(grid, X, y)
}
}
