% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta.scca.R
\name{meta.scca}
\alias{meta.scca}
\title{Meta-analytic sparse canonical correlation analysis method in integrative study}
\usage{
meta.scca(x, y, L, mu1, mu2, eps = 1e-04, scale.x = TRUE,
  scale.y = TRUE, maxstep = 50, trace = FALSE)
}
\arguments{
\item{x}{list of data matrices, L datasets of explanatory variables.}

\item{y}{list of data matrices, L datasets of dependent variables.}

\item{L}{numeric, number of datasets.}

\item{mu1}{numeric, sparsity penalty parameter for vector u.}

\item{mu2}{numeric, sparsity penalty parameter for vector v.}

\item{eps}{numeric, the threshold at which the algorithm terminates.}

\item{scale.x}{character, "TRUE" or "FALSE", whether or not to scale the variables x. The default is TRUE.}

\item{scale.y}{character, "TRUE" or "FALSE", whether or not to scale the variables y. The default is TRUE.}

\item{maxstep}{numeric, maximum iteration steps. The default value is 50.}

\item{trace}{character, "TRUE" or "FALSE". If TRUE, prints out its screening results of variables.}
}
\value{
A 'meta.scca' object that contains the list of the following items.
\itemize{
\item{x:}{ list of data matrices, L datasets of explanatory variables with centered columns. If scale.x is TRUE, the columns of L datasets are standardized to have mean 0 and standard deviation 1.}
\item{y:}{ list of data matrices, L datasets of dependent variables with centered columns. If scale.y is TRUE, the columns of L datasets are standardized to have mean 0 and standard deviation 1.}
\item{loading.x:}{ the estimated canonical vector of variables x.}
\item{loading.y:}{ the estimated canonical vector of variables y.}
\item{variable.x:}{ the screening results of variables x.}
\item{variable.y:}{ the screening results of variables y.}
\item{meanx:}{ list of numeric vectors, column mean of the original datasets x.}
\item{normx:}{ list of numeric vectors, column standard deviation of the original datasets x.}
\item{meany:}{ list of numeric vectors, column mean of the original datasets y.}
\item{normy:}{ list of numeric vectors, column standard deviation of the original datasets y.}
}
}
\description{
This function provides penalty-based sparse canonical correlation meta-analytic method to handle the multiple datasets with high dimensions generated under similar protocols, which is based on the principle of maximizing the summary statistics S.
}
\examples{
# Load a list with 3 data sets
library(iSFun)
data("simData.cca")
x <- simData.cca$x
y <- simData.cca$y
L <- length(x)
mu1 <- 0.08
mu2 <- 0.08

res <- meta.scca(x = x, y = y, L = L, mu1 = mu1, mu2 = mu2, trace = TRUE)
}
\references{
\itemize{
\item{Cichonska A, Rousu J, Marttinen P, et al. metaCCA: summary statistics-based multivariate meta-analysis of genome-wide association studies using canonical correlation analysis[J]. Bioinformatics, 2016, 32(13): 1981-1989.}
}
}
\seealso{
See Also as \code{\link{iscca}}.
}
