% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bootstrap.R
\name{PDBoot}
\alias{PDBoot}
\title{Expand bootstraping branch abundance/incience and branch length}
\usage{
PDBoot(x, labels, phy, datatype = "abundance")
}
\arguments{
\item{x}{a vector/matrix/list of species abundances or a matrix of raw incidence table.\cr}

\item{labels}{a vector of species name for input data.\cr}

\item{phy}{a phylogenetic tree with \code{"phylog"} class.\cr}

\item{datatype}{data type of input data: individual-based abundance data (\code{datatype = "abundance"}), species by sampling-units incidence matrix (\code{datatype = "incidence_raw"}).}
}
\value{
a list of data.frame with bootstraping branch abundance/incience and branch length.
}
\description{
\code{PDBoot}: Expand bootstraping branch abundance/incience and branch length
}
\examples{
data(bird)
bird.lab <- rownames(bird$abun)
bird.phy <- ade4::newick2phylog(bird$tre)
bird.inc <- bird$inci
PDBoot(bird.inc, labels=bird.lab, phy=bird.phy, datatype="incidence_raw")

}

