% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse_levels.R
\name{collapseLevels}
\alias{collapseLevels}
\title{Collapse data by values of a categorical variable}
\usage{
collapseLevels(
  .data,
  var,
  levels,
  collapse = paste(levels, collapse = "_"),
  name = sprintf("\%s.coll", var)
)
}
\arguments{
\item{.data}{a dataframe to collapse}

\item{var}{a character of the name of the categorical variable to collapse}

\item{levels}{a character vector of the levels to be collapsed}

\item{collapse}{name of the newly created level}

\item{name}{a name for the new variable}
}
\value{
the original dataframe containing a new column of the
        collapsed variable with tidyverse code attached
}
\description{
Collapse several values in a categorical variable into one level
}
\examples{
collapsed <- collapseLevels(iris, var = "Species",
    levels = c("setosa", "virginica"))
cat(code(collapsed))
head(collapsed)

}
\seealso{
\code{\link{code}}
}
\author{
Owen Jin
}
